/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.pagespec;

import com.galenframework.parser.Expectations;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.StructNode;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.pagespec.PageRule;
import com.galenframework.speclang2.pagespec.PageSpecHandler;
import com.galenframework.speclang2.pagespec.rules.Rule;
import com.galenframework.specs.Place;
import com.galenframework.specs.Spec;
import com.galenframework.specs.page.ObjectSpecs;
import com.galenframework.specs.page.PageSection;
import com.galenframework.specs.page.SpecGroup;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PageSectionProcessor {
    public static final String NO_OBJECT_NAME = null;
    private final PageSpecHandler pageSpecHandler;
    private final PageSection parentSection;

    public PageSectionProcessor(PageSpecHandler pageSpecHandler) {
        this.pageSpecHandler = pageSpecHandler;
        this.parentSection = null;
    }

    public PageSectionProcessor(PageSpecHandler pageSpecHandler, PageSection parentSection) {
        this.pageSpecHandler = pageSpecHandler;
        this.parentSection = parentSection;
    }

    public void process(StructNode sectionNode) throws IOException {
        if (sectionNode.getChildNodes() != null) {
            String sectionName = sectionNode.getName().substring(1, sectionNode.getName().length() - 1).trim();
            PageSection section = this.findSection(sectionName);
            if (section == null) {
                section = new PageSection(sectionName, sectionNode.getPlace());
                if (this.parentSection != null) {
                    this.parentSection.addSubSection(section);
                } else {
                    this.pageSpecHandler.addSection(section);
                }
            }
            this.processSection(section, sectionNode.getChildNodes());
        }
    }

    private void processSection(PageSection section, List<StructNode> childNodes) throws IOException {
        for (StructNode sectionChildNode : childNodes) {
            String childPlace = sectionChildNode.getName();
            if (PageSectionProcessor.isSectionDefinition(childPlace)) {
                new PageSectionProcessor(this.pageSpecHandler, section).process(sectionChildNode);
                continue;
            }
            if (this.isRule(childPlace)) {
                this.processSectionRule(section, sectionChildNode);
                continue;
            }
            if (this.isObject(childPlace)) {
                this.processObject(section, sectionChildNode);
                continue;
            }
            throw new SyntaxException(sectionChildNode, "Unknown statement: " + childPlace);
        }
    }

    private void processSectionRule(PageSection section, StructNode ruleNode) throws IOException {
        String ruleText = ruleNode.getName().substring(1).trim();
        Pair<PageRule, Map<String, String>> rule = this.findAndProcessRule(ruleText, ruleNode);
        PageSection ruleSection = new PageSection(ruleText, ruleNode.getPlace());
        section.addSubSection(ruleSection);
        try {
            List<StructNode> resultingNodes = ((PageRule)rule.getKey()).apply(this.pageSpecHandler, ruleText, NO_OBJECT_NAME, (Map)rule.getValue(), ruleNode.getChildNodes());
            this.processSection(ruleSection, resultingNodes);
        }
        catch (Exception ex) {
            throw new SyntaxException(ruleNode, "Error processing rule: " + ruleText, (Throwable)ex);
        }
    }

    private Pair<PageRule, Map<String, String>> findAndProcessRule(String ruleText, StructNode ruleNode) {
        ListIterator<Pair<Rule, PageRule>> iterator = this.pageSpecHandler.getPageRules().listIterator(this.pageSpecHandler.getPageRules().size());
        while (iterator.hasPrevious()) {
            Pair<Rule, PageRule> rulePair = iterator.previous();
            Matcher matcher = ((Rule)rulePair.getKey()).getPattern().matcher(ruleText);
            if (!matcher.matches()) continue;
            int index = 1;
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (String parameterName : ((Rule)rulePair.getKey()).getParameters()) {
                String value = matcher.group(index);
                this.pageSpecHandler.setGlobalVariable(parameterName, value, ruleNode);
                parameters.put(parameterName, value);
                ++index;
            }
            return new ImmutablePair(rulePair.getValue(), parameters);
        }
        throw new SyntaxException(ruleNode, "Couldn't find rule matching: " + ruleText);
    }

    private void processObjectLevelRule(ObjectSpecs objectSpecs, StructNode sourceNode) throws IOException {
        String ruleText = sourceNode.getName().substring(1).trim();
        Pair<PageRule, Map<String, String>> rule = this.findAndProcessRule(ruleText, sourceNode);
        try {
            this.pageSpecHandler.setGlobalVariable("objectName", objectSpecs.getObjectName(), sourceNode);
            List<StructNode> specNodes = ((PageRule)rule.getKey()).apply(this.pageSpecHandler, ruleText, objectSpecs.getObjectName(), (Map)rule.getValue(), sourceNode.getChildNodes());
            SpecGroup specGroup = new SpecGroup();
            specGroup.setName(ruleText);
            objectSpecs.addSpecGroup(specGroup);
            for (StructNode specNode : specNodes) {
                specGroup.addSpec(this.pageSpecHandler.getSpecReader().read(specNode.getName(), this.pageSpecHandler.getContextPath()));
            }
        }
        catch (Exception ex) {
            throw new SyntaxException(sourceNode, "Error processing rule: " + ruleText, (Throwable)ex);
        }
    }

    private boolean isRule(String nodeText) {
        return nodeText.startsWith("|");
    }

    private PageSection findSection(String sectionName) {
        if (this.parentSection != null) {
            return this.findSection(sectionName, this.parentSection.getSections());
        }
        return this.findSection(sectionName, this.pageSpecHandler.getPageSections());
    }

    private PageSection findSection(String sectionName, List<PageSection> sections) {
        for (PageSection section : sections) {
            if (!section.getName().equals(sectionName)) continue;
            return section;
        }
        return null;
    }

    private void processObject(PageSection section, StructNode objectNode) throws IOException {
        String name = objectNode.getName();
        String objectExpression = name.substring(0, name.length() - 1).trim();
        List<String> objectNames = this.pageSpecHandler.findAllObjectsMatchingStrictStatements(objectExpression);
        for (String objectName : objectNames) {
            if (objectNode.getChildNodes() == null || objectNode.getChildNodes().size() <= 0) continue;
            ObjectSpecs objectSpecs = this.findObjectSpecsInSection(section, objectName);
            if (objectSpecs == null) {
                objectSpecs = new ObjectSpecs(objectName);
                section.addObjects(objectSpecs);
            }
            for (StructNode specNode : objectNode.getChildNodes()) {
                if (this.isRule(specNode.getName())) {
                    this.processObjectLevelRule(objectSpecs, specNode);
                    continue;
                }
                this.processSpec(objectSpecs, specNode);
            }
        }
    }

    private void processSpec(ObjectSpecs objectSpecs, StructNode specNode) {
        Spec spec;
        if (specNode.getChildNodes() != null && !specNode.getChildNodes().isEmpty()) {
            throw new SyntaxException(specNode, "Specs cannot have inner blocks");
        }
        String specText = specNode.getName();
        boolean onlyWarn = false;
        if (specText.startsWith("%")) {
            specText = specText.substring(1);
            onlyWarn = true;
        }
        String alias = null;
        StringCharReader reader = new StringCharReader(specText);
        if (reader.firstNonWhiteSpaceSymbol() == '\"') {
            alias = Expectations.doubleQuotedText().read(reader);
            specText = reader.getTheRest();
        }
        try {
            spec = this.pageSpecHandler.getSpecReader().read(specText, this.pageSpecHandler.getContextPath());
        }
        catch (SyntaxException ex) {
            ex.setPlace(specNode.getPlace());
            throw ex;
        }
        spec.setOnlyWarn(onlyWarn);
        spec.setAlias(alias);
        if (specNode.getPlace() != null) {
            spec.setPlace(new Place(specNode.getPlace().getFilePath(), specNode.getPlace().getLineNumber()));
        }
        spec.setProperties(this.pageSpecHandler.getProperties());
        spec.setJsVariables(this.pageSpecHandler.getJsVariables());
        objectSpecs.getSpecs().add(spec);
    }

    private ObjectSpecs findObjectSpecsInSection(PageSection section, String objectName) {
        if (section.getObjects() != null) {
            for (ObjectSpecs objectSpecs : section.getObjects()) {
                if (!objectSpecs.getObjectName().equals(objectName)) continue;
                return objectSpecs;
            }
        }
        return null;
    }

    private boolean isObject(String childPlace) {
        return childPlace.endsWith(":");
    }

    public static boolean isSectionDefinition(String name) {
        return name.startsWith("=") && name.endsWith("=");
    }
}

