/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.pagespec;

import com.galenframework.javascript.GalenJsExecutor;
import com.galenframework.page.AbsentPageElement;
import com.galenframework.page.Page;
import com.galenframework.page.PageElement;
import com.galenframework.page.selenium.ScreenElement;
import com.galenframework.page.selenium.SeleniumPage;
import com.galenframework.page.selenium.ViewportElement;
import com.galenframework.parser.JsPageElement;
import com.galenframework.parser.StructNode;
import com.galenframework.parser.SyntaxException;
import com.galenframework.parser.VarsParser;
import com.galenframework.parser.VarsParserJsFunctions;
import com.galenframework.speclang2.pagespec.FilterFunction;
import com.galenframework.speclang2.pagespec.PageRule;
import com.galenframework.speclang2.pagespec.SectionFilter;
import com.galenframework.speclang2.pagespec.rules.Rule;
import com.galenframework.speclang2.pagespec.rules.RuleParser;
import com.galenframework.speclang2.specs.SpecReader;
import com.galenframework.specs.page.Locator;
import com.galenframework.specs.page.PageSection;
import com.galenframework.specs.page.PageSpec;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;

public class PageSpecHandler
implements VarsParserJsFunctions {
    private final PageSpec pageSpec;
    private final Page page;
    private final String contextPath;
    private final SpecReader specReader;
    private final GalenJsExecutor jsExecutor;
    private final VarsParser varsParser;
    private final List<Pair<Rule, PageRule>> pageRules;
    private final List<String> processedImports = new LinkedList<String>();
    private final List<String> processedScripts = new LinkedList<String>();
    private final Properties properties;
    private final Map<String, Object> jsVariables;
    private final SectionFilter sectionFilter;

    public PageSpecHandler(PageSpec pageSpec, Page page, SectionFilter sectionFilter, String contextPath, Properties properties, Map<String, Object> jsVariables) {
        this.pageSpec = pageSpec;
        this.page = page;
        this.sectionFilter = sectionFilter;
        this.contextPath = contextPath;
        this.specReader = new SpecReader();
        this.jsExecutor = PageSpecHandler.createGalenJsExecutor(this);
        this.pageRules = new LinkedList<Pair<Rule, PageRule>>();
        this.jsVariables = jsVariables;
        this.properties = properties != null ? properties : new Properties();
        this.varsParser = new VarsParser(new com.galenframework.suite.reader.Context(), this.properties, this.jsExecutor);
        if (jsVariables != null) {
            this.setGlobalVariables(jsVariables);
        }
    }

    public PageSpecHandler(PageSpecHandler copy, String contextPath) {
        this.pageSpec = copy.pageSpec;
        this.page = copy.page;
        this.contextPath = contextPath;
        this.specReader = copy.specReader;
        this.jsExecutor = copy.jsExecutor;
        this.varsParser = copy.varsParser;
        this.sectionFilter = copy.sectionFilter;
        this.pageRules = copy.pageRules;
        this.properties = copy.properties;
        this.jsVariables = copy.jsVariables;
    }

    private static GalenJsExecutor createGalenJsExecutor(final PageSpecHandler pageSpecHandler) {
        GalenJsExecutor js = new GalenJsExecutor();
        js.putObject("_pageSpecHandler", pageSpecHandler);
        js.evalScriptFromLibrary("GalenSpecProcessing.js");
        if (pageSpecHandler.page instanceof SeleniumPage) {
            SeleniumPage seleniumPage = (SeleniumPage)pageSpecHandler.page;
            js.putObject("screen", new JsPageElement("screen", new ScreenElement(seleniumPage.getDriver())));
            js.putObject("viewport", new JsPageElement("viewport", new ViewportElement(seleniumPage.getDriver())));
        }
        js.getScope().defineProperty("isVisible", (Object)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Should take string argument, got nothing");
                }
                if (args[0] == null) {
                    throw new IllegalArgumentException("Object name should be null");
                }
                return pageSpecHandler.isVisible(args[0].toString());
            }
        }, 2);
        js.getScope().defineProperty("isPresent", (Object)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Should take string argument, got nothing");
                }
                if (args[0] == null) {
                    throw new IllegalArgumentException("Object name should be null");
                }
                return pageSpecHandler.isPresent(args[0].toString());
            }
        }, 2);
        js.getScope().defineProperty("count", (Object)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Should take string argument, got nothing");
                }
                if (args[0] == null) {
                    throw new IllegalArgumentException("Object name should be null");
                }
                return pageSpecHandler.count(args[0].toString());
            }
        }, 2);
        js.getScope().defineProperty("find", (Object)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return pageSpecHandler.find(PageSpecHandler.getSingleStringArgument(args));
            }
        }, 2);
        js.getScope().defineProperty("findAll", (Object)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return pageSpecHandler.findAll(PageSpecHandler.getSingleStringArgument(args));
            }
        }, 2);
        js.getScope().defineProperty("first", (Object)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return pageSpecHandler.first(PageSpecHandler.getSingleStringArgument(args));
            }
        }, 2);
        js.getScope().defineProperty("last", (Object)new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return pageSpecHandler.last(PageSpecHandler.getSingleStringArgument(args));
            }
        }, 2);
        return js;
    }

    private static String getSingleStringArgument(Object[] args) {
        String singleArgument = null;
        if (args.length == 0) {
            throw new IllegalArgumentException("Should take one string argument, got none");
        }
        if (args[0] == null) {
            throw new IllegalArgumentException("Pattern should not be null");
        }
        if (args[0] instanceof NativeJavaObject) {
            NativeJavaObject njo = (NativeJavaObject)args[0];
            singleArgument = njo.unwrap().toString();
        } else {
            singleArgument = args[0].toString();
        }
        return singleArgument;
    }

    public Object isVisible(String objectName) {
        for (Map.Entry<String, Locator> object : this.pageSpec.getObjects().entrySet()) {
            if (!object.getKey().equals(objectName)) continue;
            PageElement pageElement = this.page.getObject(object.getKey(), object.getValue());
            return pageElement != null && pageElement.isPresent() && pageElement.isVisible();
        }
        return Boolean.FALSE;
    }

    public Object isPresent(String objectName) {
        for (Map.Entry<String, Locator> object : this.pageSpec.getObjects().entrySet()) {
            if (!object.getKey().equals(objectName)) continue;
            PageElement pageElement = this.page.getObject(object.getKey(), object.getValue());
            return pageElement != null && pageElement.isPresent();
        }
        return Boolean.FALSE;
    }

    public PageSpec buildPageSpec() {
        PageSpec cleanedSpec = new PageSpec();
        cleanedSpec.setObjects(this.pageSpec.getObjects());
        cleanedSpec.setSections(this.cleanEmptySections(this.pageSpec.getSections()));
        cleanedSpec.setObjectGroups(this.pageSpec.getObjectGroups());
        return cleanedSpec;
    }

    private List<PageSection> cleanEmptySections(List<PageSection> sections) {
        LinkedList<PageSection> cleanedSections = new LinkedList<PageSection>();
        for (PageSection pageSection : sections) {
            PageSection cleanedSection = pageSection.cleanSection();
            if (pageSection.isEmpty()) continue;
            cleanedSections.add(cleanedSection);
        }
        return cleanedSections;
    }

    public void addSection(PageSection section) {
        PageSection sameSection = this.findSection(section.getName());
        if (sameSection != null) {
            sameSection.mergeSection(section);
        } else {
            this.pageSpec.addSection(section);
        }
    }

    private PageSection findSection(String name) {
        for (PageSection pageSection : this.pageSpec.getSections()) {
            if (!pageSection.getName().equals(name)) continue;
            return pageSection;
        }
        return null;
    }

    public SpecReader getSpecReader() {
        return this.specReader;
    }

    public void addObjectToSpec(String objectName, Locator locator) {
        this.pageSpec.addObject(objectName, locator);
    }

    @Override
    public int count(String regex) {
        List<String> objectNames = this.pageSpec.findOnlyExistingMatchingObjectNames(regex);
        return objectNames.size();
    }

    @Override
    public JsPageElement find(String name) {
        List<String> objectNames = this.pageSpec.findOnlyExistingMatchingObjectNames(name);
        if (!objectNames.isEmpty()) {
            PageElement pageElement;
            String objectName = objectNames.get(0);
            Locator locator = this.pageSpec.getObjects().get(objectName);
            if (locator != null && this.page != null && (pageElement = this.page.getObject(objectName, locator)) != null) {
                return new JsPageElement(objectName, pageElement);
            }
        }
        return new JsPageElement(name, new AbsentPageElement());
    }

    @Override
    public JsPageElement[] findAll(String objectsStatements) {
        List<String> objectNames = this.pageSpec.findAllObjectsMatchingStrictStatements(objectsStatements);
        ArrayList<JsPageElement> jsElements = new ArrayList<JsPageElement>(objectNames.size());
        for (String objectName : objectNames) {
            Locator locator = this.pageSpec.getObjects().get(objectName);
            PageElement pageElement = null;
            if (locator != null) {
                pageElement = this.page.getObject(objectName, locator);
            }
            if (pageElement != null) {
                jsElements.add(new JsPageElement(objectName, pageElement));
                continue;
            }
            jsElements.add(new JsPageElement(objectName, new AbsentPageElement()));
        }
        return jsElements.toArray(new JsPageElement[jsElements.size()]);
    }

    @Override
    public JsPageElement first(String objectsStatements) {
        return this.extractSingleElement(objectsStatements, list -> (String)list.get(0));
    }

    @Override
    public JsPageElement last(String objectsStatements) {
        return this.extractSingleElement(objectsStatements, list -> (String)list.get(list.size() - 1));
    }

    private JsPageElement extractSingleElement(String objectsStatements, FilterFunction<String> filterFunction) {
        List<String> objectNames = this.pageSpec.findAllObjectsMatchingStrictStatements(objectsStatements);
        PageElement pageElement = null;
        String objectName = objectsStatements;
        if (!objectNames.isEmpty()) {
            objectName = filterFunction.filter(objectNames);
            Locator locator = this.pageSpec.getObjects().get(objectName);
            if (locator != null) {
                pageElement = this.page.getObject(objectName, locator);
            }
        }
        if (pageElement != null) {
            return new JsPageElement(objectName, pageElement);
        }
        return new JsPageElement(objectName, new AbsentPageElement());
    }

    public void setGlobalVariable(String name, Object value, StructNode source) {
        if (!this.isValidVariableName(name)) {
            throw new SyntaxException(source, "Invalid name for variable: " + name);
        }
        if (value != null && value instanceof NativeJavaObject) {
            this.jsExecutor.putObject(name, ((NativeJavaObject)value).unwrap());
        } else {
            this.jsExecutor.putObject(name, value);
        }
    }

    private boolean isValidVariableName(String name) {
        if (name.isEmpty()) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char symbol = name.charAt(i);
            if (symbol > '@' && symbol < '[' || symbol > '`' && symbol < '{' || symbol > '/' && symbol < ':' && i > 0 || symbol == '_') continue;
            return false;
        }
        return true;
    }

    public VarsParser getVarsParser() {
        return this.varsParser;
    }

    public StructNode processExpressionsIn(StructNode originNode) {
        String result;
        try {
            result = this.getVarsParser().parse(originNode.getName());
        }
        catch (Exception ex) {
            throw new SyntaxException(originNode, "JavaScript error inside statement", (Throwable)ex);
        }
        StructNode processedNode = new StructNode(result);
        processedNode.setPlace(originNode.getPlace());
        processedNode.setChildNodes(originNode.getChildNodes());
        return processedNode;
    }

    public void setGlobalVariables(Map<String, Object> variables, StructNode originNode) {
        for (Map.Entry<String, Object> variable : variables.entrySet()) {
            this.setGlobalVariable(variable.getKey(), variable.getValue(), originNode);
        }
    }

    public void setGlobalVariables(Map<String, Object> variables) {
        this.setGlobalVariables(variables, StructNode.UNKNOWN_SOURCE);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public List<PageSection> getPageSections() {
        return this.pageSpec.getSections();
    }

    public void runJavaScriptFromFile(String scriptPath) {
        this.jsExecutor.runJavaScriptFromFile(scriptPath);
    }

    public String getFullPathToResource(String scriptPath) {
        if (this.contextPath != null) {
            return this.contextPath + "/" + scriptPath;
        }
        return scriptPath;
    }

    public void addRule(String ruleText, PageRule pageRule) {
        Rule rule = new RuleParser().parse(ruleText);
        this.pageRules.add((Pair<Rule, PageRule>)new ImmutablePair((Object)rule, (Object)pageRule));
    }

    public List<Pair<Rule, PageRule>> getPageRules() {
        return this.pageRules;
    }

    public void runJavaScript(String completeScript) {
        this.jsExecutor.eval(completeScript);
    }

    public List<String> getProcessedImports() {
        return this.processedImports;
    }

    public List<String> getProcessedScripts() {
        return this.processedScripts;
    }

    public Page getPage() {
        return this.page;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Map<String, Object> getJsVariables() {
        return this.jsVariables;
    }

    public SectionFilter getSectionFilter() {
        return this.sectionFilter;
    }

    public void applyGroupsToObject(String objectName, List<String> groups) {
        if (!objectName.isEmpty()) {
            for (String groupName : groups) {
                groupName = groupName.trim();
                List<String> groupObjectsList = this.pageSpec.getObjectGroups().get(groupName);
                if (groupObjectsList != null) {
                    if (groupObjectsList.contains(objectName)) continue;
                    groupObjectsList.add(objectName);
                    continue;
                }
                groupObjectsList = new LinkedList<String>();
                groupObjectsList.add(objectName);
                this.pageSpec.getObjectGroups().put(groupName, groupObjectsList);
            }
        }
    }

    public List<String> findAllObjectsMatchingStrictStatements(String objectStatements) {
        return this.pageSpec.findAllObjectsMatchingStrictStatements(objectStatements);
    }
}

