/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.pagespec;

import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.StructNode;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.pagespec.InPageRule;
import com.galenframework.speclang2.pagespec.PageSpecHandler;
import com.galenframework.speclang2.pagespec.StructNodeProcessor;
import java.util.Collections;
import java.util.List;

public class RuleProcessor
implements StructNodeProcessor {
    private final PageSpecHandler pageSpecHandler;

    public RuleProcessor(PageSpecHandler pageSpecHandler) {
        this.pageSpecHandler = pageSpecHandler;
    }

    @Override
    public List<StructNode> process(StringCharReader reader, StructNode statementNode) {
        String ruleText = reader.getTheRest().trim();
        if (ruleText.isEmpty()) {
            throw new SyntaxException(statementNode, "Missing rule text");
        }
        if (statementNode.getChildNodes() == null || statementNode.getChildNodes().size() == 0) {
            throw new SyntaxException(statementNode, "A rule is empty");
        }
        this.pageSpecHandler.addRule(ruleText, new InPageRule(statementNode.getChildNodes()));
        return Collections.emptyList();
    }
}

