/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.pagespec.rules;

import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.pagespec.rules.Rule;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class RuleBuilder {
    private List<Chunk> chunks = new LinkedList<Chunk>();

    public NormalTextChunk newNormalTextChunk() {
        return this.addChunk(new NormalTextChunk());
    }

    public ParameterChunk newParameterChunk() {
        return this.addChunk(new ParameterChunk());
    }

    public WhiteSpaceChunk newWhiteSpaceChunk() {
        return this.addChunk(new WhiteSpaceChunk());
    }

    public <T extends Chunk> T addChunk(T chunk) {
        this.chunks.add(chunk);
        return chunk;
    }

    public Rule build() {
        Rule rule = new Rule();
        StringBuilder patternBuilder = new StringBuilder();
        for (Chunk chunk : this.chunks) {
            patternBuilder.append(chunk.build(rule));
        }
        rule.setPattern(Pattern.compile(patternBuilder.toString()));
        return rule;
    }

    public static class ParameterChunk
    extends Chunk {
        private static final int PARSE_NAME = 0;
        private static final int PARSE_PARAMETER = 1;
        private int state = 0;
        private StringBuilder nameBuilder = new StringBuilder();
        private StringBuilder regexBuilder = new StringBuilder();
        private final Pattern objectNamePattern = Pattern.compile("[a-zA-Z0-9_]+");

        @Override
        public String build(Rule rule) {
            String parameterName = this.nameBuilder.toString().toString().trim();
            if (parameterName.isEmpty()) {
                throw new SyntaxException("Parameter name should not be empty");
            }
            if (this.containsInvalidSymbolsForName(parameterName)) {
                throw new SyntaxException("Incorrect parameter name: " + parameterName);
            }
            rule.addParameter(parameterName);
            String customRegex = this.regexBuilder.toString().trim();
            if (customRegex.isEmpty()) {
                if (this.isStillParsingName()) {
                    customRegex = ".*";
                } else {
                    throw new SyntaxException("Missing custom regular expression after ':'");
                }
            }
            return "(" + customRegex + ")";
        }

        private boolean containsInvalidSymbolsForName(String parameterName) {
            return !this.objectNamePattern.matcher(parameterName).matches();
        }

        @Override
        public void appendSymbol(char symbol) {
            if (symbol == ':' && this.isStillParsingName()) {
                this.startParsingCustomRegex();
            } else if (this.isStillParsingName()) {
                this.nameBuilder.append(symbol);
            } else {
                this.regexBuilder.append(symbol);
            }
        }

        private boolean isStillParsingName() {
            return this.state == 0;
        }

        private void startParsingCustomRegex() {
            this.state = 1;
        }
    }

    public static class NormalTextChunk
    extends Chunk {
        private StringBuilder stringBuilder = new StringBuilder();

        @Override
        public String build(Rule rule) {
            String text = this.stringBuilder.toString();
            if (text.isEmpty()) {
                return text;
            }
            return Pattern.quote(text);
        }

        @Override
        public void appendSymbol(char ch) {
            this.stringBuilder.append(ch);
        }
    }

    public class WhiteSpaceChunk
    extends Chunk {
        @Override
        public String build(Rule rule) {
            return "\\s+";
        }

        @Override
        public void appendSymbol(char ch) {
        }
    }

    public static abstract class Chunk {
        public abstract String build(Rule var1);

        public abstract void appendSymbol(char var1);
    }
}

