/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.specs;

import com.galenframework.parser.SyntaxException;

public enum Alignment {
    CENTERED,
    TOP,
    BOTTOM,
    LEFT,
    RIGHT,
    ALL;


    public static Alignment parse(String alignmentText) {
        if (alignmentText.equals("centered")) {
            return CENTERED;
        }
        if (alignmentText.equals("top")) {
            return TOP;
        }
        if (alignmentText.equals("bottom")) {
            return BOTTOM;
        }
        if (alignmentText.equals("left")) {
            return LEFT;
        }
        if (alignmentText.equals("right")) {
            return RIGHT;
        }
        if (alignmentText.equals("all")) {
            return ALL;
        }
        throw new SyntaxException(String.format("Unknown alignment \"%s\"", alignmentText));
    }

    public String toString() {
        switch (this) {
            case CENTERED: {
                return "centered";
            }
            case TOP: {
                return "top";
            }
            case BOTTOM: {
                return "bottom";
            }
            case LEFT: {
                return "left";
            }
            case RIGHT: {
                return "right";
            }
            case ALL: {
                return "all";
            }
        }
        return "";
    }

    public boolean isOneOf(Alignment ... alignments) {
        for (Alignment a : alignments) {
            if (this != a) continue;
            return true;
        }
        return false;
    }
}

