/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.specs;

import com.galenframework.page.Rect;
import com.galenframework.parser.Expectations;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.SyntaxException;
import com.galenframework.rainbow4j.filters.ImageFilter;
import com.galenframework.specs.Spec;
import java.util.LinkedList;
import java.util.List;

public class SpecImage
extends Spec {
    private List<String> ignoredObjectExpressions;
    private List<String> imagePaths;
    private ErrorRate errorRate;
    private Integer tolerance;
    private List<ImageFilter> originalFilters = new LinkedList<ImageFilter>();
    private List<ImageFilter> sampleFilters = new LinkedList<ImageFilter>();
    private List<ImageFilter> mapFilters = new LinkedList<ImageFilter>();
    private Rect selectedArea;
    private boolean stretch = false;
    private boolean cropIfOutside = false;
    private int analyzeOffset = 0;

    public List<String> getIgnoredObjectExpressions() {
        return this.ignoredObjectExpressions;
    }

    public void setIgnoredObjectExpressions(List<String> ignoredObjectExpressions) {
        this.ignoredObjectExpressions = ignoredObjectExpressions;
    }

    public int getAnalyzeOffset() {
        return this.analyzeOffset;
    }

    public void setAnalyzeOffset(int analyzeOffset) {
        this.analyzeOffset = analyzeOffset;
    }

    public Integer getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(Integer tolerance) {
        this.tolerance = tolerance;
    }

    public Rect getSelectedArea() {
        return this.selectedArea;
    }

    public void setSelectedArea(Rect selectedArea) {
        this.selectedArea = selectedArea;
    }

    public List<ImageFilter> getMapFilters() {
        return this.mapFilters;
    }

    public void setMapFilters(List<ImageFilter> mapFilters) {
        this.mapFilters = mapFilters;
    }

    public boolean isStretch() {
        return this.stretch;
    }

    public void setStretch(boolean stretch) {
        this.stretch = stretch;
    }

    public List<String> getImagePaths() {
        return this.imagePaths;
    }

    public void setImagePaths(List<String> imagePaths) {
        this.imagePaths = imagePaths;
    }

    public List<ImageFilter> getOriginalFilters() {
        return this.originalFilters;
    }

    public void setOriginalFilters(List<ImageFilter> originalFilters) {
        this.originalFilters = originalFilters;
    }

    public List<ImageFilter> getSampleFilters() {
        return this.sampleFilters;
    }

    public void setSampleFilters(List<ImageFilter> sampleFilters) {
        this.sampleFilters = sampleFilters;
    }

    public boolean isCropIfOutside() {
        return this.cropIfOutside;
    }

    public void setCropIfOutside(boolean cropIfOutside) {
        this.cropIfOutside = cropIfOutside;
    }

    public ErrorRate getErrorRate() {
        return this.errorRate;
    }

    public void setErrorRate(ErrorRate errorRate) {
        this.errorRate = errorRate;
    }

    public static class ErrorRate {
        private Double value;
        private ErrorRateType type;

        public ErrorRate(Double value, ErrorRateType type) {
            this.value = value;
            this.type = type;
        }

        public Double getValue() {
            return this.value;
        }

        public void setValue(Double value) {
            this.value = value;
        }

        public ErrorRateType getType() {
            return this.type;
        }

        public void setType(ErrorRateType type) {
            this.type = type;
        }

        public static ErrorRate fromString(String errorRateText) {
            ErrorRateType type;
            if (errorRateText == null || errorRateText.trim().isEmpty()) {
                return new ErrorRate(0.0, ErrorRateType.PIXELS);
            }
            StringCharReader reader = new StringCharReader(errorRateText);
            Double value = Expectations.number().read(reader);
            String rest = reader.getTheRest().trim();
            if (rest.isEmpty() || rest.equals("px")) {
                type = ErrorRateType.PIXELS;
            } else if (rest.equals("%")) {
                type = ErrorRateType.PERCENT;
            } else {
                throw new SyntaxException("Can't read error rate value for image spec: " + errorRateText);
            }
            return new ErrorRate(value, type);
        }
    }

    public static enum ErrorRateType {
        PIXELS("px"),
        PERCENT("%");

        private final String name;

        private ErrorRateType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

