/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.specs;

import com.galenframework.parser.SyntaxException;
import com.galenframework.specs.Spec;
import java.util.List;

public class SpecOcr
extends Spec {
    private List<String> operations;
    private Type type;
    private String text;

    public List<String> getOperations() {
        return this.operations;
    }

    public void setOperations(List<String> operations) {
        this.operations = operations;
    }

    public Spec withOperations(List<String> operations) {
        this.setOperations(operations);
        return this;
    }

    public SpecOcr(Type type, String text) {
        this.setType(type);
        this.setText(text);
    }

    public SpecOcr(Type type, String text, List<String> operations) {
        this.setType(type);
        this.setText(text);
        this.setOperations(operations);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public static enum Type {
        IS("is"),
        CONTAINS("contains"),
        STARTS("starts"),
        ENDS("ends"),
        MATCHES("matches");

        private final String operationName;

        private Type(String operationName) {
            this.operationName = operationName;
        }

        public static Type fromString(String typeString) {
            for (Type type : Type.values()) {
                if (!type.operationName.equals(typeString)) continue;
                return type;
            }
            throw new SyntaxException("Unknown validation type: " + typeString);
        }

        public static boolean isValid(String typeString) {
            for (Type type : Type.values()) {
                if (!type.operationName.equals(typeString)) continue;
                return true;
            }
            return false;
        }
    }
}

