/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.specs.page;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class CorrectionsRect {
    private Correction left;
    private Correction top;
    private Correction width;
    private Correction height;

    public CorrectionsRect(Correction left, Correction top, Correction width, Correction height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
    }

    public Correction getLeft() {
        return this.left;
    }

    public void setLeft(Correction left) {
        this.left = left;
    }

    public Correction getTop() {
        return this.top;
    }

    public void setTop(Correction top) {
        this.top = top;
    }

    public Correction getWidth() {
        return this.width;
    }

    public void setWidth(Correction width) {
        this.width = width;
    }

    public Correction getHeight() {
        return this.height;
    }

    public void setHeight(Correction height) {
        this.height = height;
    }

    public static CorrectionsRect simpleCorrectionRect(int left, int top, int width, int height) {
        return new CorrectionsRect(CorrectionsRect.simpleCorrectionValue(left), CorrectionsRect.simpleCorrectionValue(top), CorrectionsRect.simpleCorrectionValue(width), CorrectionsRect.simpleCorrectionValue(height));
    }

    private static Correction simpleCorrectionValue(int value) {
        Type type = Type.PLUS;
        if (value < 0) {
            type = Type.MINUS;
        }
        return new Correction(Math.abs(value), type);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CorrectionsRect)) {
            return false;
        }
        CorrectionsRect rhs = (CorrectionsRect)obj;
        return new EqualsBuilder().append((Object)this.left, (Object)rhs.left).append((Object)this.top, (Object)rhs.top).append((Object)this.width, (Object)rhs.width).append((Object)this.height, (Object)rhs.height).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.left).append((Object)this.top).append((Object)this.width).append((Object)this.height).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("left", (Object)this.left).append("top", (Object)this.top).append("width", (Object)this.width).append("height", (Object)this.height).toString();
    }

    public static class Correction {
        private int value;
        private Type type = Type.PLUS;

        public Correction(int value, Type type) {
            this.value = value;
            this.type = type;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public int correct(int oldValue) {
            if (this.type == Type.PLUS) {
                return oldValue + this.value;
            }
            if (this.type == Type.MINUS) {
                return oldValue - this.value;
            }
            if (this.type == Type.EQUALS) {
                return this.value;
            }
            return oldValue;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Correction)) {
                return false;
            }
            Correction rhs = (Correction)obj;
            return new EqualsBuilder().append(this.value, rhs.value).append((Object)this.type, (Object)rhs.type).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.value).append((Object)this.type).toHashCode();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("value", this.value).append("type", (Object)this.type).toString();
        }
    }

    public static enum Type {
        MINUS,
        PLUS,
        EQUALS;

    }
}

