/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.specs.page;

import com.galenframework.specs.page.CorrectionsRect;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Locator {
    private String locatorType;
    private String locatorValue;
    private CorrectionsRect corrections;
    private int index = 0;
    private Locator parent;

    public Locator(String locatorType, String locatorValue) {
        this(locatorType, locatorValue, 0);
    }

    public Locator(String locatorType, String locatorValue, int index) {
        this.setLocatorType(locatorType);
        this.setLocatorValue(locatorValue);
        this.setIndex(index);
    }

    public String getLocatorType() {
        return this.locatorType;
    }

    public void setLocatorType(String locatorType) {
        this.locatorType = locatorType;
    }

    public String getLocatorValue() {
        return this.locatorValue;
    }

    public void setLocatorValue(String locatorValue) {
        this.locatorValue = locatorValue;
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 19).append((Object)this.locatorType).append((Object)this.locatorValue).append((Object)this.parent).append((Object)this.getCorrections()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Locator)) {
            return false;
        }
        Locator rhs = (Locator)obj;
        return new EqualsBuilder().append((Object)this.locatorType, (Object)rhs.locatorType).append((Object)this.locatorValue, (Object)rhs.locatorValue).append((Object)this.parent, (Object)rhs.parent).append((Object)this.getCorrections(), (Object)rhs.getCorrections()).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("locatorType", (Object)this.locatorType).append("locatorValue", (Object)this.locatorValue).append("parent", (Object)this.parent).append("corrections", (Object)this.getCorrections()).toString();
    }

    public String prettyString() {
        return this.locatorType + ": " + this.locatorValue;
    }

    public Locator withCorrections(CorrectionsRect corrections) {
        this.setCorrections(corrections);
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public CorrectionsRect getCorrections() {
        return this.corrections;
    }

    public void setCorrections(CorrectionsRect corrections) {
        this.corrections = corrections;
    }

    public static Locator css(String cssText) {
        return new Locator("css", cssText, 0);
    }

    public static Locator xpath(String xpathText) {
        return new Locator("xpath", xpathText, 0);
    }

    public static Locator id(String idText) {
        return new Locator("id", idText);
    }

    public static Locator parse(String text) {
        int index = text.indexOf(":");
        if (index > 0) {
            String type = text.substring(0, index);
            if (type.equals("id")) {
                return Locator.id(text.substring(index + 1).trim());
            }
            if (type.equals("xpath")) {
                return Locator.xpath(text.substring(index + 1).trim());
            }
            if (type.equals("css")) {
                return Locator.css(text.substring(index + 1).trim());
            }
        }
        return Locator.css(text);
    }

    public Locator withParent(Locator parent) {
        this.parent = parent;
        return this;
    }

    public Locator getParent() {
        return this.parent;
    }

    public void setParent(Locator parent) {
        this.parent = parent;
    }
}

