/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.suite.actions;

import com.galenframework.browser.Browser;
import com.galenframework.reports.TestReport;
import com.galenframework.suite.GalenPageAction;
import com.galenframework.suite.GalenPageTest;
import com.galenframework.tests.TestSession;
import com.galenframework.validation.ValidationListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class GalenPageActionProperties
extends GalenPageAction {
    private List<String> files;

    @Override
    public void execute(TestReport report, Browser browser, GalenPageTest pageTest, ValidationListener validationListener) throws Exception {
        if (this.files != null) {
            for (String filePath : this.files) {
                File file = new File(filePath);
                if (!file.exists()) {
                    throw new FileNotFoundException("File does not exist: " + filePath);
                }
                if (!file.isFile()) {
                    throw new FileNotFoundException("Not a file: " + filePath);
                }
                TestSession.current().getProperties().load(new FileReader(file));
            }
        }
    }

    public void setFiles(List<String> files) {
        this.files = files;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public GalenPageActionProperties withFiles(List<String> files) {
        this.setFiles(files);
        return this;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.files).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GalenPageActionProperties)) {
            return false;
        }
        GalenPageActionProperties rhs = (GalenPageActionProperties)obj;
        return new EqualsBuilder().append(this.files, rhs.files).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("files", this.files).toString();
    }
}

