/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.suite.actions.mutation;

import com.galenframework.page.Rect;
import com.galenframework.suite.actions.mutation.MutationOptions;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class AreaMutation {
    private String mutationName;
    private Function<Rect, Rect> mutationFunction;

    public AreaMutation(String mutationName, Function<Rect, Rect> mutationFunction) {
        this.mutationName = mutationName;
        this.mutationFunction = mutationFunction;
    }

    public static List<AreaMutation> generateStandardMutations(MutationOptions options) {
        int offset = options.getPositionOffset();
        return Arrays.asList(new AreaMutation(String.format("drag left by %dpx", offset), area -> area.drag(-offset, 0)), new AreaMutation(String.format("drag right by %dpx", offset), area -> area.drag(offset, 0)), new AreaMutation(String.format("drag top by %dpx", offset), area -> area.drag(0, -offset)), new AreaMutation(String.format("drag down by %dpx", offset), area -> area.drag(0, offset)), new AreaMutation(String.format("increase width by %dpx", offset), area -> area.distort(0, 0, offset, 0)), new AreaMutation(String.format("decrease width by %dpx", offset), area -> area.distort(0, 0, -offset, 0)), new AreaMutation(String.format("increase height by %dpx", offset), area -> area.distort(0, 0, 0, offset)), new AreaMutation(String.format("decrease height by %dpx", offset), area -> area.distort(0, 0, 0, -offset)), new AreaMutation(String.format("move left edge right by %dpx", offset), area -> area.distort(offset, 0, -offset, 0)), new AreaMutation(String.format("move top edge down by %dpx", offset), area -> area.distort(0, offset, 0, -offset)));
    }

    public String getMutationName() {
        return this.mutationName;
    }

    public void setMutationName(String mutationName) {
        this.mutationName = mutationName;
    }

    public Function<Rect, Rect> getMutationFunction() {
        return this.mutationFunction;
    }

    public void setMutationFunction(Function<Rect, Rect> mutationFunction) {
        this.mutationFunction = mutationFunction;
    }

    public Rect mutate(Rect area) {
        return this.mutationFunction.apply(area);
    }
}

