/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.suite.actions.mutation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.galenframework.reports.model.LayoutReport;
import com.galenframework.suite.actions.mutation.PageElementMutation;
import com.galenframework.suite.actions.mutation.PageMutation;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MutationReport {
    private Map<String, MutationStatistic> objectMutationStatistics = new HashMap<String, MutationStatistic>();
    private int totalPassed = 0;
    private int totalFailed = 0;
    @JsonIgnore
    private LayoutReport initialLayoutReport;
    private String error;

    public void reportSuccessMutation(PageMutation pageMutation) {
        MutationStatistic mutationStatistic = this.obtainObjectMutationStatistic(pageMutation);
        mutationStatistic.passed++;
        ++this.totalPassed;
    }

    public void reportFailedMutation(PageMutation pageMutation) {
        MutationStatistic mutationStatistic = this.obtainObjectMutationStatistic(pageMutation);
        mutationStatistic.failed++;
        mutationStatistic.failedMutations.add(this.convertElementMutationsToString(pageMutation.getPageElementMutations()));
        ++this.totalFailed;
    }

    private String convertElementMutationsToString(List<PageElementMutation> pageElementMutations) {
        StringBuilder s = new StringBuilder();
        boolean isFirst = true;
        for (PageElementMutation pageElementMutation : pageElementMutations) {
            if (!isFirst) {
                s.append(" and ");
            }
            s.append(pageElementMutation.getElementName());
            s.append(": ");
            s.append(pageElementMutation.getAreaMutation().getMutationName());
            isFirst = false;
        }
        return s.toString();
    }

    private MutationStatistic obtainObjectMutationStatistic(PageMutation pageMutation) {
        String objectName = pageMutation.getPageElementMutations().get(0).getElementName();
        MutationStatistic mutationStatistic = this.objectMutationStatistics.get(objectName);
        if (mutationStatistic == null) {
            mutationStatistic = new MutationStatistic();
            this.objectMutationStatistics.put(objectName, mutationStatistic);
        }
        return mutationStatistic;
    }

    public int getTotalPassed() {
        return this.totalPassed;
    }

    public int getTotalFailed() {
        return this.totalFailed;
    }

    public void setInitialLayoutReport(LayoutReport initialLayoutReport) {
        this.initialLayoutReport = initialLayoutReport;
    }

    public LayoutReport getInitialLayoutReport() {
        return this.initialLayoutReport;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public int getTotalMutations() {
        return this.totalFailed + this.totalPassed;
    }

    public double getFailedRatio() {
        int total = this.getTotalMutations();
        if (total > 0) {
            return 100.0 * (double)this.totalFailed / (double)total;
        }
        return 0.0;
    }

    public boolean hasErrors() {
        return this.error != null || this.getTotalFailed() > 0;
    }

    public List<String> allFailedMutations() {
        return this.objectMutationStatistics.values().stream().map(s -> ((MutationStatistic)s).failedMutations).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Map<String, MutationStatistic> getObjectMutationStatistics() {
        return this.objectMutationStatistics;
    }

    public class MutationStatistic {
        private int passed = 0;
        private int failed = 0;
        private List<String> failedMutations = new LinkedList<String>();

        public int getPassed() {
            return this.passed;
        }

        public int getFailed() {
            return this.failed;
        }

        public List<String> getFailedMutations() {
            return this.failedMutations;
        }
    }
}

