/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.suite.reader;

import com.galenframework.parser.SyntaxException;
import com.galenframework.specs.Place;
import com.galenframework.suite.reader.RowVisitor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class Table {
    private List<String> headers;
    private List<List<String>> rows = new LinkedList<List<String>>();

    public void addRow(List<String> row, Place place) {
        if (this.headers == null) {
            this.headers = row;
        } else {
            if (row.size() != this.headers.size()) {
                throw new SyntaxException(place, "Amount of cells in a row is not the same in header");
            }
            this.rows.add(row);
        }
    }

    public void mergeWith(Table table) {
        if (table.headers != null && table.rows.size() > 0) {
            if (table.headers.size() != this.headers.size()) {
                throw new SyntaxException("Cannot merge tables. Amount of columns should be same");
            }
            for (List<String> row : table.rows) {
                this.rows.add(row);
            }
        }
    }

    public void forEach(RowVisitor visitor) {
        for (List<String> row : this.rows) {
            int index = -1;
            HashMap<String, String> values = new HashMap<String, String>();
            for (String cell : row) {
                values.put(this.headers.get(++index), cell);
            }
            visitor.visit(values);
        }
    }
}

