/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.suite.reader;

import com.galenframework.parser.SyntaxException;
import com.galenframework.parser.VarsContext;
import com.galenframework.specs.Place;
import com.galenframework.suite.reader.Node;
import java.util.LinkedList;
import java.util.List;

public class TableRowNode
extends Node<List<String>> {
    public TableRowNode(String text, Place place) {
        super(text, place);
    }

    @Override
    public List<String> build(VarsContext context) {
        String rowText = this.getArguments().trim();
        if (!rowText.startsWith("|")) {
            throw new SyntaxException(this.getPlace(), "Incorrect format. Should start with '|'");
        }
        if (!rowText.endsWith("|")) {
            throw new SyntaxException(this.getPlace(), "Incorrect format. Should end with '|'");
        }
        String[] rawCells = rowText.split("\\|");
        LinkedList<String> cells = new LinkedList<String>();
        if (rawCells.length > 1) {
            for (int i = 1; i < rawCells.length; ++i) {
                cells.add(context.process(rawCells[i].trim()));
            }
        } else {
            throw new SyntaxException(this.getPlace(), "Incorrect row. Use '|' symbol to split values");
        }
        return cells;
    }

    @Override
    public Node<?> processNewNode(String text, Place place) {
        throw new SyntaxException(place, "Wrong nesting");
    }
}

