/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.suite.reader;

import com.galenframework.parser.VarsContext;
import com.galenframework.specs.Place;
import com.galenframework.suite.GalenPageTest;
import com.galenframework.suite.reader.Node;
import com.galenframework.suite.reader.PageNode;
import com.galenframework.tests.GalenBasicTest;
import java.util.LinkedList;
import java.util.List;

public class TestNode
extends Node<GalenBasicTest> {
    private boolean disabled = false;
    private List<String> groups;

    public TestNode(String text, Place place) {
        super(text, place);
    }

    @Override
    public Node<?> processNewNode(String text, Place line) {
        PageNode pageNode = new PageNode(text, line);
        this.add(pageNode);
        return pageNode;
    }

    @Override
    public GalenBasicTest build(VarsContext context) {
        GalenBasicTest test = new GalenBasicTest();
        LinkedList<GalenPageTest> pageTests = new LinkedList<GalenPageTest>();
        test.setName(context.process(this.getArguments()));
        test.setPageTests(pageTests);
        test.setGroups(this.groups);
        for (Node<?> childNode : this.getChildNodes()) {
            if (!(childNode instanceof PageNode)) continue;
            PageNode pageNode = (PageNode)childNode;
            pageTests.add(pageNode.build(context));
        }
        return test;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public List<String> getGroups() {
        return this.groups;
    }
}

