/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.tests;

import com.galenframework.reports.GalenTestInfo;
import com.galenframework.reports.TestReport;
import com.galenframework.runner.CompleteListener;
import com.galenframework.tests.GalenProperties;
import com.galenframework.tests.GalenTest;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class TestSession {
    private static final ThreadLocal<TestSession> _sessions = new ThreadLocal();
    private static final ReentrantLock lock = new ReentrantLock();
    private GalenTestInfo testInfo;
    private Map<String, Object> data = new HashMap<String, Object>();
    private TestReport report = new TestReport();
    private CompleteListener listener;
    private GalenProperties properties = new GalenProperties();

    private TestSession(GalenTestInfo testInfo) {
        this.setTestInfo(testInfo);
    }

    public static TestSession register(GalenTestInfo info) {
        lock.lock();
        try {
            TestSession session = new TestSession(info);
            _sessions.set(session);
            TestSession testSession = session;
            return testSession;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            lock.unlock();
        }
    }

    public static void clear() {
        _sessions.remove();
    }

    public GalenTestInfo getTestInfo() {
        return this.testInfo;
    }

    public void setTestInfo(GalenTestInfo testInfo) {
        this.testInfo = testInfo;
    }

    public static TestSession current() {
        return _sessions.get();
    }

    public void put(String name, Object value) {
        this.data.put(name, value);
    }

    public Object get(String name) {
        return this.data.get(name);
    }

    public void setReport(TestReport report) {
        this.report = report;
    }

    public TestReport getReport() {
        return this.report;
    }

    public void setListener(CompleteListener listener) {
        this.listener = listener;
    }

    public CompleteListener getListener() {
        return this.listener;
    }

    public GalenTest getTest() {
        if (this.testInfo != null) {
            return this.testInfo.getTest();
        }
        return null;
    }

    public GalenProperties getProperties() {
        return this.properties;
    }

    public void setProperties(GalenProperties properties) {
        this.properties = properties;
    }
}

