/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation;

import com.galenframework.specs.Spec;
import com.galenframework.specs.page.PageSection;
import com.galenframework.suite.GalenPageAction;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.ValidationListener;
import com.galenframework.validation.ValidationResult;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedValidationListener
implements ValidationListener {
    private static final Logger LOG = LoggerFactory.getLogger(CombinedValidationListener.class);
    private List<ValidationListener> listeners = new LinkedList<ValidationListener>();

    @Override
    public void onObject(PageValidation pageValidation, String objectName) {
        for (ValidationListener listener : this.listeners) {
            try {
                listener.onObject(pageValidation, objectName);
            }
            catch (Exception ex) {
                LOG.error("Unknown error during finishing test", (Throwable)ex);
            }
        }
    }

    @Override
    public void onAfterObject(PageValidation pageValidation, String objectName) {
        for (ValidationListener listener : this.listeners) {
            try {
                listener.onAfterObject(pageValidation, objectName);
            }
            catch (Exception ex) {
                LOG.error("Unknown error during finishing test", (Throwable)ex);
            }
        }
    }

    @Override
    public void onBeforeSpec(PageValidation pageValidation, String objectName, Spec spec) {
        for (ValidationListener listener : this.listeners) {
            try {
                listener.onBeforeSpec(pageValidation, objectName, spec);
            }
            catch (Exception ex) {
                LOG.error("Unknown error during finishing test", (Throwable)ex);
            }
        }
    }

    @Override
    public void onSpecError(PageValidation pageValidation, String objectName, Spec spec, ValidationResult result) {
        for (ValidationListener listener : this.listeners) {
            try {
                listener.onSpecError(pageValidation, objectName, spec, result);
            }
            catch (Exception ex) {
                LOG.error("Unknown error during finishing test", (Throwable)ex);
            }
        }
    }

    @Override
    public void onSpecSuccess(PageValidation pageValidation, String objectName, Spec spec, ValidationResult result) {
        for (ValidationListener listener : this.listeners) {
            try {
                listener.onSpecSuccess(pageValidation, objectName, spec, result);
            }
            catch (Exception ex) {
                LOG.error("Unknown error during finishing test", (Throwable)ex);
            }
        }
    }

    @Override
    public void onGlobalError(Exception e) {
        for (ValidationListener listener : this.listeners) {
            try {
                listener.onGlobalError(e);
            }
            catch (Exception ex) {
                LOG.error("Unknown error during finishing test", (Throwable)ex);
            }
        }
    }

    @Override
    public void onBeforePageAction(GalenPageAction action) {
        for (ValidationListener listener : this.listeners) {
            try {
                listener.onBeforePageAction(action);
            }
            catch (Exception ex) {
                LOG.error("Unknown error during finishing test", (Throwable)ex);
            }
        }
    }

    @Override
    public void onAfterPageAction(GalenPageAction action) {
        for (ValidationListener listener : this.listeners) {
            try {
                listener.onAfterPageAction(action);
            }
            catch (Exception ex) {
                LOG.error("Unknown error during finishing test", (Throwable)ex);
            }
        }
    }

    @Override
    public void onBeforeSection(PageValidation pageValidation, PageSection pageSection) {
        for (ValidationListener listener : this.listeners) {
            try {
                listener.onBeforeSection(pageValidation, pageSection);
            }
            catch (Exception ex) {
                LOG.error("Unknown error during finishing test", (Throwable)ex);
            }
        }
    }

    @Override
    public void onAfterSection(PageValidation pageValidation, PageSection pageSection) {
        for (ValidationListener listener : this.listeners) {
            try {
                listener.onAfterSection(pageValidation, pageSection);
            }
            catch (Exception ex) {
                LOG.error("Unknown error during finishing test", (Throwable)ex);
            }
        }
    }

    @Override
    public void onSubLayout(PageValidation pageValidation, String objectName) {
        for (ValidationListener listener : this.listeners) {
            try {
                listener.onSubLayout(pageValidation, objectName);
            }
            catch (Exception ex) {
                LOG.error("Unknown error during finishing test", (Throwable)ex);
            }
        }
    }

    @Override
    public void onAfterSubLayout(PageValidation pageValidation, String objectName) {
        for (ValidationListener listener : this.listeners) {
            try {
                listener.onAfterSubLayout(pageValidation, objectName);
            }
            catch (Exception ex) {
                LOG.error("Unknown error during finishing test", (Throwable)ex);
            }
        }
    }

    @Override
    public void onSpecGroup(PageValidation pageValidation, String specGroupName) {
        for (ValidationListener listener : this.listeners) {
            try {
                listener.onSpecGroup(pageValidation, specGroupName);
            }
            catch (Exception ex) {
                LOG.error("Unknown error during finishing test", (Throwable)ex);
            }
        }
    }

    @Override
    public void onAfterSpecGroup(PageValidation pageValidation, String specGroupName) {
        for (ValidationListener listener : this.listeners) {
            try {
                listener.onAfterSpecGroup(pageValidation, specGroupName);
            }
            catch (Exception ex) {
                LOG.error("Unknown error during finishing test", (Throwable)ex);
            }
        }
    }

    public void add(ValidationListener validationListener) {
        if (validationListener != null) {
            this.listeners.add(validationListener);
        }
    }
}

