/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation.specs;

import com.galenframework.page.PageElement;
import com.galenframework.page.Rect;
import com.galenframework.reports.model.LayoutMeta;
import com.galenframework.specs.Location;
import com.galenframework.specs.Range;
import com.galenframework.specs.Side;
import com.galenframework.specs.Spec;
import com.galenframework.specs.SpecComplex;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.SimpleValidationResult;
import com.galenframework.validation.SpecValidation;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.ValidationResult;
import com.galenframework.validation.ValidationUtils;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public abstract class SpecValidationComplex<T extends SpecComplex>
extends SpecValidation<T> {
    @Override
    public ValidationResult check(PageValidation pageValidation, String objectName, T spec) throws ValidationErrorException {
        PageElement mainObject = pageValidation.findPageElement(objectName);
        this.checkAvailability(mainObject, objectName);
        PageElement secondObject = pageValidation.findPageElement(((SpecComplex)spec).getObject());
        this.checkAvailability(secondObject, ((SpecComplex)spec).getObject());
        Rect mainArea = mainObject.getArea();
        Rect secondArea = secondObject.getArea();
        List<ValidationObject> objects = Arrays.asList(new ValidationObject(mainArea, objectName), new ValidationObject(secondArea, ((SpecComplex)spec).getObject()));
        this.doCustomValidations(objectName, mainArea, secondArea, spec, objects);
        List<LayoutMeta> layoutMeta = this.validateAllSides(pageValidation, objectName, mainArea, secondArea, spec, objects);
        return new ValidationResult((Spec)spec, objects).withMeta(layoutMeta);
    }

    protected void doCustomValidations(String objectName, Rect mainArea, Rect secondArea, T spec, List<ValidationObject> objects) throws ValidationErrorException {
    }

    protected abstract SimpleValidationResult validateSide(String var1, T var2, Range var3, Side var4, Rect var5, Rect var6, PageValidation var7);

    protected List<LayoutMeta> validateAllSides(PageValidation pageValidation, String objectName, Rect mainArea, Rect secondArea, T spec, List<ValidationObject> validationObjects) throws ValidationErrorException {
        LinkedList<LayoutMeta> meta = new LinkedList<LayoutMeta>();
        LinkedList<String> errorMessages = new LinkedList<String>();
        for (Location location : ((SpecComplex)spec).getLocations()) {
            Range range = location.getRange();
            LinkedList<String> perLocationErrors = new LinkedList<String>();
            for (Side side : location.getSides()) {
                SimpleValidationResult svr = this.validateSide(objectName, spec, range, side, mainArea, secondArea, pageValidation);
                meta.add(svr.getMeta());
                if (!svr.isError()) continue;
                perLocationErrors.add(svr.getError());
            }
            if (perLocationErrors.isEmpty()) continue;
            errorMessages.add(this.convertPerLocationErrors(pageValidation, range, perLocationErrors));
        }
        if (errorMessages.size() > 0) {
            throw new ValidationErrorException().withMessage(ValidationUtils.joinErrorMessagesForObject(errorMessages, objectName)).withValidationObjects(validationObjects).withMeta(meta);
        }
        return meta;
    }

    private String convertPerLocationErrors(PageValidation pageValidation, Range range, List<String> perLocationErrors) {
        String calculatedFromPercentage = "";
        if (range.isPercentage()) {
            calculatedFromPercentage = " " + ValidationUtils.rangeCalculatedFromPercentage(range, pageValidation.getObjectValue(range.getPercentageOfValue()));
        }
        return String.format("%s %s%s", ValidationUtils.joinMessages(perLocationErrors, " and "), range.getErrorMessageSuffix(), calculatedFromPercentage);
    }
}

