/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation.specs;

import com.galenframework.page.PageElement;
import com.galenframework.page.Rect;
import com.galenframework.specs.Spec;
import com.galenframework.specs.SpecText;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.SpecValidation;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.ValidationResult;
import com.galenframework.validation.specs.TextOperation;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class SpecValidationText<T extends SpecText>
extends SpecValidation<T> {
    @Override
    public ValidationResult check(PageValidation pageValidation, String objectName, T spec) throws ValidationErrorException {
        PageElement mainObject = pageValidation.findPageElement(objectName);
        this.checkAvailability(mainObject, objectName);
        Rect area = mainObject.getArea();
        String realText = mainObject.getText();
        if (realText == null) {
            realText = "";
        }
        realText = new String(realText.getBytes(Charset.forName("utf-8")));
        realText = this.applyOperationsTo(realText, ((SpecText)spec).getOperations());
        this.checkValue((SpecText)spec, objectName, realText, "text", area);
        return new ValidationResult((Spec)spec, Arrays.asList(new ValidationObject(area, objectName)));
    }

    private String applyOperationsTo(String text, List<String> operations) {
        if (operations != null) {
            for (String operation : operations) {
                text = TextOperation.find(operation).apply(text);
            }
        }
        return text;
    }

    protected void checkValue(SpecText spec, String objectName, String realText, String checkEntity, Rect area) throws ValidationErrorException {
        if (spec.getType() == SpecText.Type.IS) {
            this.checkIs(objectName, area, realText, spec.getText(), checkEntity);
        }
        if (spec.getType() == SpecText.Type.CONTAINS) {
            this.checkContains(objectName, area, realText, spec.getText(), checkEntity);
        } else if (spec.getType() == SpecText.Type.STARTS) {
            this.checkStarts(objectName, area, realText, spec.getText(), checkEntity);
        } else if (spec.getType() == SpecText.Type.ENDS) {
            this.checkEnds(objectName, area, realText, spec.getText(), checkEntity);
        } else if (spec.getType() == SpecText.Type.MATCHES) {
            this.checkMatches(objectName, area, realText, spec.getText(), checkEntity);
        }
    }

    protected void checkIs(String objectName, Rect area, String realText, String text, String checkEntity) throws ValidationErrorException {
        if (!realText.equals(text)) {
            throw new ValidationErrorException(Arrays.asList(new ValidationObject(area, objectName)), Arrays.asList(String.format("\"%s\" %s is \"%s\" but should be \"%s\"", objectName, checkEntity, realText, text)));
        }
    }

    protected void checkStarts(String objectName, Rect area, String realText, String text, String checkEntity) throws ValidationErrorException {
        if (!realText.startsWith(text)) {
            throw new ValidationErrorException(Arrays.asList(new ValidationObject(area, objectName)), Arrays.asList(String.format("\"%s\" %s is \"%s\" but should start with \"%s\"", objectName, checkEntity, realText, text)));
        }
    }

    protected void checkEnds(String objectName, Rect area, String realText, String text, String checkEntity) throws ValidationErrorException {
        if (!realText.endsWith(text)) {
            throw new ValidationErrorException(Arrays.asList(new ValidationObject(area, objectName)), Arrays.asList(String.format("\"%s\" %s is \"%s\" but should end with \"%s\"", objectName, checkEntity, realText, text)));
        }
    }

    protected void checkMatches(String objectName, Rect area, String realText, String text, String checkEntity) throws ValidationErrorException {
        Pattern regex = Pattern.compile(text, 32);
        if (!regex.matcher(realText).matches()) {
            throw new ValidationErrorException(Arrays.asList(new ValidationObject(area, objectName)), Arrays.asList(String.format("\"%s\" %s is \"%s\" but should match \"%s\"", objectName, checkEntity, realText, text)));
        }
    }

    protected void checkContains(String objectName, Rect area, String realText, String text, String checkEntity) throws ValidationErrorException {
        if (!realText.contains(text)) {
            throw new ValidationErrorException(Arrays.asList(new ValidationObject(area, objectName)), Arrays.asList(String.format("\"%s\" %s is \"%s\" but should contain \"%s\"", objectName, checkEntity, realText, text)));
        }
    }
}

