/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation.specs;

import com.galenframework.parser.SyntaxException;
import java.util.HashMap;
import java.util.Map;

public abstract class TextOperation {
    private static final Map<String, TextOperation> _operations = new HashMap<String, TextOperation>(){
        {
            this.put("lowercase", new TextOperation(){

                @Override
                public String apply(String text) {
                    return text.toLowerCase();
                }
            });
            this.put("uppercase", new TextOperation(){

                @Override
                public String apply(String text) {
                    return text.toUpperCase();
                }
            });
            this.put("singleline", new TextOperation(){

                @Override
                public String apply(String text) {
                    return text.replaceAll("(\\r|\\n|\\r\\n)+", " ");
                }
            });
        }
    };

    public abstract String apply(String var1);

    public static TextOperation find(String operation) {
        if (_operations.containsKey(operation)) {
            return _operations.get(operation);
        }
        throw new SyntaxException("Unsupported text operation: " + operation);
    }
}

