/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.junit;

import com.galenframework.junit.GalenReportTestRunner;
import com.galenframework.reports.GalenTestInfo;
import com.galenframework.support.GalenJavaTestBase;
import com.galenframework.support.GalenReportsContainer;
import java.util.Date;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;

@RunWith(value=GalenReportTestRunner.class)
public abstract class GalenJUnitTestBase
extends GalenJavaTestBase {
    @Before
    public void initReport() {
        GalenTestInfo ti = GalenTestInfo.fromString((String)this.getTestName());
        this.testInfo.set(ti);
        this.report.set(GalenReportsContainer.get().registerTest(ti));
    }

    public String getTestName() {
        return GalenJUnitTestBase.getCaller();
    }

    public abstract WebDriver createDriver();

    @Override
    public WebDriver createDriver(Object[] args) {
        return this.createDriver();
    }

    @Before
    public void initDriver() {
        super.initDriver(null);
    }

    @Override
    @After
    public void quitDriver() {
        super.quitDriver();
    }

    @After
    public void provideTestEndDate() {
        GalenTestInfo ti = (GalenTestInfo)this.testInfo.get();
        if (ti != null) {
            ti.setEndedAt(new Date());
        }
    }

    private static String getCaller() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        String callerMethodName = elements[3].getMethodName();
        String callerClassName = elements[3].getClassName();
        return callerClassName + "#>" + callerMethodName;
    }
}

