/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.rainbow4j.filters;

import com.galenframework.rainbow4j.filters.ImageFilter;
import java.awt.Rectangle;
import java.nio.ByteBuffer;

public class EdgesFilter
implements ImageFilter {
    private int tolerance = 30;

    public EdgesFilter(int tolerance) {
        this.tolerance = tolerance;
    }

    @Override
    public void apply(ByteBuffer bytes, int width, int height, Rectangle area) {
        int powTolerance = (int)Math.pow(this.tolerance, 2.0);
        for (int y = area.y; y < area.y + area.height - 1; ++y) {
            for (int x = area.x; x < area.x + area.width - 1; ++x) {
                int k = y * width * 4 + x * 4;
                int kh = y * width * 4 + (x + 1) * 4;
                int kv = (y + 1) * width * 4 + x * 4;
                int diffH = 0;
                int diffV = 0;
                for (int i = 0; i < 3; ++i) {
                    diffH = (int)((double)diffH + Math.pow(bytes.get(k + i) - bytes.get(kh + i), 2.0));
                    diffV = (int)((double)diffH + Math.pow(bytes.get(k + i) - bytes.get(kv + i), 2.0));
                }
                if (diffH > powTolerance || diffV > powTolerance) {
                    bytes.put(k, (byte)-1);
                    bytes.put(k + 1, (byte)-1);
                    bytes.put(k + 2, (byte)-1);
                    continue;
                }
                bytes.put(k, (byte)0);
                bytes.put(k + 1, (byte)0);
                bytes.put(k + 2, (byte)0);
            }
        }
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(int tolerance) {
        this.tolerance = tolerance;
    }
}

