/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.http.exception;

import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DbUnavailableState implements HasName
{
    NONE("None", 0),
    CONNECTION_FAILURE("ConnectionFailure", 1),
    UNKNOWN_DATABASE("UnknownDatabase", 2),
    INITIALIZING("Initializing", 3),
    OPERATION_ABORTED("OperationAborted", 4);

    private static final Logger log;
    private final String name;
    private final int code;

    private DbUnavailableState(String name, int code) {
        this.name = name;
        this.code = code;
    }

    public static DbUnavailableState findOrDefault(String name) {
        if (Util.isEmpty(name)) {
            log.warn("Empty value is not recognized for {} enum; returning default {}", (Object)DbUnavailableState.class.getSimpleName(), (Object)NONE);
            return NONE;
        }
        for (DbUnavailableState dbUnavailableState : DbUnavailableState.values()) {
            if (!dbUnavailableState.getName().equalsIgnoreCase(name.trim())) continue;
            return dbUnavailableState;
        }
        log.warn("{} is not recognized for {} enum; returning default {}", new Object[]{name, DbUnavailableState.class.getSimpleName(), NONE});
        return NONE;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    @JsonValue
    public String getName() {
        return this.name;
    }

    static {
        log = LoggerFactory.getLogger(DbUnavailableState.class);
    }
}

