/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.http.exception;

import com.geotab.util.Util;

public class ResponseFailException
extends RuntimeException {
    private int httpStatusCode;
    private String url;

    public ResponseFailException(int httpStatusCode, String resultAsString, Exception innerException) {
        this(null, httpStatusCode, resultAsString, innerException);
    }

    public ResponseFailException(String url, int httpStatusCode, String resultAsString, Exception innerException) {
        super(resultAsString, innerException);
        this.httpStatusCode = httpStatusCode;
        this.url = url;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Override
    public String getMessage() {
        String message = String.format("StatusCode: %d; %s", this.httpStatusCode, super.getMessage());
        if (Util.isEmpty(this.url)) {
            return message;
        }
        return String.format("Url: %s; %s'", this.url, message);
    }

    public String getUrl() {
        return this.url;
    }
}

