/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.http.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.geotab.http.request.param.EmptyParameters;
import com.geotab.http.request.param.Parameters;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class BaseRequest<T extends Parameters> {
    private static final Parameters EMPTY_PARAMETERS = new EmptyParameters();
    protected Integer id;
    protected String method;
    protected T params;
    @JsonIgnore
    protected Map<String, Object> httpHeaders;

    public BaseRequest() {
        this(null, null, EMPTY_PARAMETERS, null);
    }

    public BaseRequest(Integer id, String method, T params) {
        this(id, method, params, null);
    }

    public BaseRequest(Integer id, String method, T params, Map<String, Object> httpHeaders) {
        this.id = id;
        this.method = method;
        this.params = Optional.ofNullable(params).orElse(EMPTY_PARAMETERS);
        this.httpHeaders = Optional.ofNullable(httpHeaders).orElse(new HashMap());
    }

    protected BaseRequest(BaseRequestBuilder<T, ?, ?> b) {
        this.id = b.id;
        this.method = b.method;
        this.params = b.params;
        this.httpHeaders = b.httpHeaders;
    }

    public static <T extends Parameters> BaseRequestBuilder<T, ?, ?> requestBuilder() {
        return new BaseRequestBuilderImpl();
    }

    public Map<String, Object> getHttpHeaders() {
        return this.httpHeaders;
    }

    @JsonIgnore
    public BaseRequest<T> setHttpHeaders(Map<String, Object> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    public Integer getId() {
        return this.id;
    }

    public BaseRequest<T> setId(Integer id) {
        this.id = id;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public BaseRequest<T> setMethod(String method) {
        this.method = method;
        return this;
    }

    public T getParams() {
        return this.params;
    }

    public BaseRequest<T> setParams(T params) {
        this.params = params;
        return this;
    }

    public String toString() {
        return "BaseRequest(id=" + this.getId() + ", method=" + this.getMethod() + ", params=" + String.valueOf(this.getParams()) + ", httpHeaders=" + String.valueOf(this.getHttpHeaders()) + ")";
    }

    public static abstract class BaseRequestBuilder<T extends Parameters, C extends BaseRequest<T>, B extends BaseRequestBuilder<T, C, B>> {
        private Integer id;
        private String method;
        private T params;
        private Map<String, Object> httpHeaders;

        public abstract C build();

        @JsonIgnore
        public B httpHeaders(Map<String, Object> httpHeaders) {
            this.httpHeaders = httpHeaders;
            return this.self();
        }

        public B id(Integer id) {
            this.id = id;
            return this.self();
        }

        public B method(String method) {
            this.method = method;
            return this.self();
        }

        public B params(T params) {
            this.params = params;
            return this.self();
        }

        protected abstract B self();

        public String toString() {
            return "BaseRequest.BaseRequestBuilder(id=" + this.id + ", method=" + this.method + ", params=" + String.valueOf(this.params) + ", httpHeaders=" + String.valueOf(this.httpHeaders) + ")";
        }
    }

    private static final class BaseRequestBuilderImpl<T extends Parameters>
    extends BaseRequestBuilder<T, BaseRequest<T>, BaseRequestBuilderImpl<T>> {
        private BaseRequestBuilderImpl() {
        }

        @Override
        public BaseRequest<T> build() {
            return new BaseRequest(this);
        }

        @Override
        protected BaseRequestBuilderImpl<T> self() {
            return this;
        }
    }
}

