/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.error;

import com.geotab.model.error.Error;
import com.geotab.model.error.JsonRpcErrorData;
import java.util.Arrays;

public class JsonRpcError {
    private String message;
    private Integer code;
    private JsonRpcErrorData data;
    private String name;
    private Error[] errors;

    public JsonRpcError(String message, Integer code, JsonRpcErrorData data, String name, Error[] errors) {
        this.message = message;
        this.code = code;
        this.data = data;
        this.name = name;
        this.errors = errors;
    }

    public JsonRpcError() {
    }

    public static JsonRpcErrorBuilder builder() {
        return new JsonRpcErrorBuilder();
    }

    public Integer getCode() {
        return this.code;
    }

    public JsonRpcErrorData getData() {
        return this.data;
    }

    public Error[] getErrors() {
        return this.errors;
    }

    public String getMessage() {
        return this.message;
    }

    public String getName() {
        return this.name;
    }

    public JsonRpcError setCode(Integer code) {
        this.code = code;
        return this;
    }

    public JsonRpcError setData(JsonRpcErrorData data) {
        this.data = data;
        return this;
    }

    public JsonRpcError setErrors(Error[] errors) {
        this.errors = errors;
        return this;
    }

    public JsonRpcError setMessage(String message) {
        this.message = message;
        return this;
    }

    public JsonRpcError setName(String name) {
        this.name = name;
        return this;
    }

    public String toString() {
        return "JsonRpcError(message=" + this.getMessage() + ", code=" + this.getCode() + ", data=" + String.valueOf(this.getData()) + ", name=" + this.getName() + ", errors=" + Arrays.deepToString(this.getErrors()) + ")";
    }

    public static class JsonRpcErrorBuilder {
        private String message;
        private Integer code;
        private JsonRpcErrorData data;
        private String name;
        private Error[] errors;

        JsonRpcErrorBuilder() {
        }

        public JsonRpcError build() {
            return new JsonRpcError(this.message, this.code, this.data, this.name, this.errors);
        }

        public JsonRpcErrorBuilder code(Integer code) {
            this.code = code;
            return this;
        }

        public JsonRpcErrorBuilder data(JsonRpcErrorData data) {
            this.data = data;
            return this;
        }

        public JsonRpcErrorBuilder errors(Error[] errors) {
            this.errors = errors;
            return this;
        }

        public JsonRpcErrorBuilder message(String message) {
            this.message = message;
            return this;
        }

        public JsonRpcErrorBuilder name(String name) {
            this.name = name;
            return this;
        }

        public String toString() {
            return "JsonRpcError.JsonRpcErrorBuilder(message=" + this.message + ", code=" + this.code + ", data=" + String.valueOf(this.data) + ", name=" + this.name + ", errors=" + Arrays.deepToString(this.errors) + ")";
        }
    }
}

