/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.login;

import com.geotab.http.request.param.Parameters;
import com.geotab.util.Util;
import java.util.Objects;

public class Credentials
extends Parameters {
    private String userName;
    private String password;
    private String database = "";
    private String sessionId;

    public Credentials() {
    }

    public Credentials(String userName, String password, String database, String sessionId) {
        if (Util.isEmpty(password) && Util.isEmpty(sessionId)) {
            throw new IllegalArgumentException("Must provide either password or session ID");
        }
        this.database = database;
        this.userName = userName;
        this.password = password;
        this.sessionId = sessionId;
    }

    protected Credentials(CredentialsBuilder<?, ?> b) {
        super(b);
        this.userName = b.userName;
        this.password = b.password;
        this.database = b.database;
        this.sessionId = b.sessionId;
    }

    public static CredentialsBuilder<?, ?> builder() {
        return new CredentialsBuilderImpl();
    }

    public String getDatabase() {
        return this.database;
    }

    public Credentials setDatabase(String database) {
        this.database = database;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.sessionId = null;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Credentials setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public Credentials setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Credentials)) {
            return false;
        }
        Credentials that = (Credentials)o;
        return Objects.equals(this.getUserName(), that.getUserName()) && Objects.equals(this.getPassword(), that.getPassword()) && Objects.equals(this.getDatabase(), that.getDatabase()) && Objects.equals(this.getSessionId(), that.getSessionId());
    }

    public int hashCode() {
        int result = Objects.hashCode(this.getUserName());
        result = 31 * result + Objects.hashCode(this.getPassword());
        result = 31 * result + Objects.hashCode(this.getDatabase());
        result = 31 * result + Objects.hashCode(this.getSessionId());
        return result;
    }

    @Override
    public String toString() {
        return this.userName + "@" + this.database;
    }

    public void validate() {
        if (Util.isEmpty(this.userName)) {
            throw new IllegalArgumentException("Invalid user name");
        }
        if (Util.isEmpty(this.password) && Util.isEmpty(this.sessionId)) {
            throw new IllegalArgumentException("Must supply password or sessionId");
        }
    }

    public static abstract class CredentialsBuilder<C extends Credentials, B extends CredentialsBuilder<C, B>>
    extends Parameters.ParametersBuilder<C, B> {
        private String userName;
        private String password;
        private String database;
        private String sessionId;

        @Override
        public abstract C build();

        public B database(String database) {
            this.database = database;
            return (B)this.self();
        }

        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        public B sessionId(String sessionId) {
            this.sessionId = sessionId;
            return (B)this.self();
        }

        public B userName(String userName) {
            this.userName = userName;
            return (B)this.self();
        }
    }

    private static final class CredentialsBuilderImpl
    extends CredentialsBuilder<Credentials, CredentialsBuilderImpl> {
        private CredentialsBuilderImpl() {
        }

        @Override
        public Credentials build() {
            return new Credentials(this);
        }

        @Override
        protected CredentialsBuilderImpl self() {
            return this;
        }
    }
}

