/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.serialization.serdes;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.geotab.util.Util;
import java.io.IOException;
import java.time.Duration;

public interface DurationSerde {
    public static Duration durationFromString(String str) {
        int dotIndex;
        if (Util.isEmpty(str)) {
            return null;
        }
        if (!str.matches("^[-]?(\\d+[.])?\\d{1,2}:\\d{1,2}:\\d{1,2}([.]\\d{1,7})?$")) {
            throw new IllegalArgumentException("Unexpected duration pattern for value " + str + ", expected [-][d.]hh:mm:ss[.fffffff]");
        }
        String[] parts = str.split(":");
        String[] secondsParts = parts[2].split("\\.");
        Duration out = Duration.ZERO;
        boolean isNegated = false;
        if (parts[0].startsWith("-")) {
            parts[0] = parts[0].substring(1);
            isNegated = true;
        }
        if ((dotIndex = parts[0].indexOf(46)) > -1) {
            String[] dayParts = parts[0].split("\\.");
            out = out.plusDays(Integer.parseInt(dayParts[0]));
            parts[0] = parts[0].substring(dotIndex + 1);
        }
        out = out.plusHours(Integer.parseInt(parts[0])).plusMinutes(Integer.parseInt(parts[1])).plusSeconds(Integer.parseInt(secondsParts[0]));
        if (secondsParts.length > 1) {
            out = out.plusNanos(Long.parseLong(String.format("%1$-7s", secondsParts[1]).replaceAll(" ", "0")) * 100L);
        }
        return isNegated ? out.negated() : out;
    }

    public static String durationToString(Duration duration) {
        if (duration == null) {
            return null;
        }
        long seconds = Math.abs(duration.getSeconds());
        long nano = Math.abs(duration.getNano());
        long days = seconds / 86400L;
        StringBuilder out = new StringBuilder();
        if (duration.isNegative()) {
            out.append("-");
        }
        if (days > 0L) {
            out.append(days).append('.');
        }
        out.append(String.format("%02d:%02d:%02d", seconds % 86400L / 3600L, seconds % 3600L / 60L, seconds % 60L));
        if (nano > 0L) {
            out.append('.').append(String.format("%07d", nano / 100L));
        }
        return out.toString();
    }

    public static class DurationSerializer
    extends JsonSerializer<Duration> {
        public void serialize(Duration value, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
            jsonGenerator.writeString(DurationSerde.durationToString(value));
        }
    }

    public static class DurationDeserializer
    extends JsonDeserializer<Duration> {
        public Duration deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            return DurationSerde.durationFromString(jsonParser.getText());
        }
    }
}

