/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.serialization.serdes;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

public class LongDeserializer
extends JsonDeserializer<Long> {
    public Long deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        ObjectCodec parserCodec = jsonParser.getCodec();
        JsonNode node = (JsonNode)parserCodec.readTree(jsonParser);
        if (node.isTextual()) {
            String longAsString = node.textValue();
            return LongDeserializer.stringToLong(longAsString);
        }
        if (node.isNumber()) {
            return node.asLong();
        }
        return null;
    }

    private static Long stringToLong(String longAsString) {
        if (longAsString == null) {
            return null;
        }
        long l = LongDeserializer.charToHex(longAsString.charAt(0));
        for (int i = 1; i < 16; ++i) {
            l <<= 4;
            l |= LongDeserializer.charToHex(longAsString.charAt(i));
        }
        return l;
    }

    private static long charToHex(char c) {
        return c > '9' ? (long)(c - 97 + 10) : (long)(c - 48);
    }
}

