/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.serialization.serdes.ByteArrayDeserializer;
import com.geotab.model.serialization.serdes.ByteArraySerializer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class CustomParameter {
    @JsonDeserialize(using=ByteArrayDeserializer.class)
    @JsonSerialize(using=ByteArraySerializer.class)
    private Byte[] bytes;
    private String description;
    @JsonProperty(value="isEnabled")
    private boolean isEnabled;
    private Integer offset;

    public static boolean isBitMappedOptionParameter(CustomParameter parameter) {
        if (parameter.getBytes().length == 1) {
            switch (parameter.getOffset()) {
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 58: 
                case 63: 
                case 64: 
                case 65: 
                case 66: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean isResetDriverIdAtIgnitionOff(List<CustomParameter> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return false;
        }
        for (CustomParameter customParameter : parameters) {
            if (!customParameter.getIsEnabled() || customParameter.getBytes().length != 1 || customParameter.getBytes()[0] != 16) continue;
            return true;
        }
        return false;
    }

    public static boolean isDriverBlacklistParameter(CustomParameter parameter) {
        return parameter.getOffset() >= 94 && parameter.getOffset() <= 110;
    }

    public static boolean isNotOverlapping(List<CustomParameter> parameters) {
        for (CustomParameter customParameter : parameters) {
            if (!customParameter.getIsEnabled()) continue;
            for (CustomParameter compareTo : parameters) {
                if (customParameter.equals(compareTo) || !compareTo.getIsEnabled() || !(CustomParameter.isBitMappedOptionParameter(customParameter) ? customParameter.getOffset().equals(compareTo.getOffset()) && customParameter.getBytes()[0].equals(compareTo.getBytes()[0]) : customParameter.getOffset() <= compareTo.getOffset() + compareTo.getBytes().length - 1 && customParameter.getOffset() + customParameter.getBytes().length - 1 >= compareTo.getOffset())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CustomParameter)) {
            return false;
        }
        CustomParameter customParameter = (CustomParameter)object;
        return Arrays.equals((Object[])this.bytes, (Object[])customParameter.getBytes()) && Objects.equals(this.description, customParameter.getDescription()) && this.isEnabled == customParameter.getIsEnabled() && this.offset.equals(customParameter.getOffset());
    }

    public int hashCode() {
        int hash = 823118405;
        if (this.bytes != null) {
            for (Byte b : this.bytes) {
                hash ^= b.hashCode();
            }
        }
        hash = hash ^ (this.description != null ? this.description : "").hashCode() ^ Boolean.valueOf(this.isEnabled).hashCode() ^ this.offset.hashCode();
        return hash;
    }

    @Generated
    public static CustomParameterBuilder builder() {
        return new CustomParameterBuilder();
    }

    @Generated
    public Byte[] getBytes() {
        return this.bytes;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean getIsEnabled() {
        return this.isEnabled;
    }

    @Generated
    public Integer getOffset() {
        return this.offset;
    }

    @JsonDeserialize(using=ByteArrayDeserializer.class)
    @Generated
    public CustomParameter setBytes(Byte[] bytes) {
        this.bytes = bytes;
        return this;
    }

    @Generated
    public CustomParameter setDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="isEnabled")
    @Generated
    public CustomParameter setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Generated
    public CustomParameter setOffset(Integer offset) {
        this.offset = offset;
        return this;
    }

    @Generated
    public CustomParameter() {
    }

    @Generated
    public CustomParameter(Byte[] bytes, String description, boolean isEnabled, Integer offset) {
        this.bytes = bytes;
        this.description = description;
        this.isEnabled = isEnabled;
        this.offset = offset;
    }

    @Generated
    public static class CustomParameterBuilder {
        @Generated
        private Byte[] bytes;
        @Generated
        private String description;
        @Generated
        private boolean isEnabled;
        @Generated
        private Integer offset;

        @Generated
        CustomParameterBuilder() {
        }

        @JsonDeserialize(using=ByteArrayDeserializer.class)
        @Generated
        public CustomParameterBuilder bytes(Byte[] bytes) {
            this.bytes = bytes;
            return this;
        }

        @Generated
        public CustomParameterBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="isEnabled")
        @Generated
        public CustomParameterBuilder isEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        @Generated
        public CustomParameterBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        @Generated
        public CustomParameter build() {
            return new CustomParameter(this.bytes, this.description, this.isEnabled, this.offset);
        }

        @Generated
        public String toString() {
            return "CustomParameter.CustomParameterBuilder(bytes=" + Arrays.deepToString(this.bytes) + ", description=" + this.description + ", isEnabled=" + this.isEnabled + ", offset=" + this.offset + ")";
        }
    }
}

