/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.drawing;

import lombok.Generated;

public class Color {
    public static final Color RED = new Color(255, 0, 0);
    public static final Color WHITE = new Color(255, 255, 255);
    public static final Color GREEN = new Color(0, 255, 0);
    public static final Color BLUE = new Color(0, 0, 255);
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color EMPTY = new Color(0, 0, 0);
    private int r;
    private int g;
    private int b;
    private int a;

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public int toArgb() {
        return (this.a & 0xFF) << 24 | (this.r & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.b & 0xFF;
    }

    @Generated
    public static ColorBuilder colorBuilder() {
        return new ColorBuilder();
    }

    @Generated
    public int getR() {
        return this.r;
    }

    @Generated
    public int getG() {
        return this.g;
    }

    @Generated
    public int getB() {
        return this.b;
    }

    @Generated
    public int getA() {
        return this.a;
    }

    @Generated
    public Color setR(int r) {
        this.r = r;
        return this;
    }

    @Generated
    public Color setG(int g) {
        this.g = g;
        return this;
    }

    @Generated
    public Color setB(int b) {
        this.b = b;
        return this;
    }

    @Generated
    public Color setA(int a) {
        this.a = a;
        return this;
    }

    @Generated
    public Color() {
    }

    @Generated
    public static class ColorBuilder {
        @Generated
        private int r;
        @Generated
        private int g;
        @Generated
        private int b;
        @Generated
        private int a;

        @Generated
        ColorBuilder() {
        }

        @Generated
        public ColorBuilder r(int r) {
            this.r = r;
            return this;
        }

        @Generated
        public ColorBuilder g(int g) {
            this.g = g;
            return this;
        }

        @Generated
        public ColorBuilder b(int b) {
            this.b = b;
            return this;
        }

        @Generated
        public ColorBuilder a(int a) {
            this.a = a;
            return this;
        }

        @Generated
        public Color build() {
            return new Color(this.r, this.g, this.b, this.a);
        }

        @Generated
        public String toString() {
            return "Color.ColorBuilder(r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + ")";
        }
    }
}

