/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.device;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.geotab.model.entity.device.CustomDevice;
import com.geotab.model.entity.device.DeviceType;
import com.geotab.model.entity.device.EngineHoursAdjustmentProviderAware;
import com.geotab.model.entity.device.HosOption;
import com.geotab.model.entity.device.LicensableAware;
import com.geotab.model.entity.device.OdometerAdjustmentProviderAware;
import com.geotab.model.entity.device.VehicleIdentificationNumberAware;
import com.geotab.util.DeviceDefaultsUtil;
import lombok.Generated;

public class CustomVehicleDevice
extends CustomDevice
implements VehicleIdentificationNumberAware,
OdometerAdjustmentProviderAware,
EngineHoursAdjustmentProviderAware,
LicensableAware {
    private String vehicleIdentificationNumber;
    private String engineVehicleIdentificationNumber;
    private Double odometer;
    private Float odometerFactor;
    private Double odometerOffset;
    private Double engineHours;
    private Integer engineHourOffset;
    private String licensePlate;
    private String licenseState;
    @JsonProperty(value="pinDevice")
    private Boolean pinDevice;
    private Boolean disableSleeperBerth;
    private HosOption autoHos;
    private Double fuelTankCapacity;

    @Override
    public void populateDefaults() {
        super.populateDefaults();
        DeviceDefaultsUtil.addCustomVehicleDeviceDefaults(this);
    }

    @JsonIgnore
    public boolean isAutomaticVehicleManagementEnabled() {
        return this.pinDevice == null || this.pinDevice == false;
    }

    @Override
    public Boolean isPinDevice() {
        return this.getPinDevice();
    }

    @Generated
    protected CustomVehicleDevice(CustomVehicleDeviceBuilder<?, ?> b) {
        super((CustomDevice.CustomDeviceBuilder<?, ?>)b);
        this.setDeviceType(DeviceType.CUSTOM_VEHICLE_DEVICE);
        this.vehicleIdentificationNumber = b.vehicleIdentificationNumber;
        this.engineVehicleIdentificationNumber = b.engineVehicleIdentificationNumber;
        this.odometer = b.odometer;
        this.odometerFactor = b.odometerFactor;
        this.odometerOffset = b.odometerOffset;
        this.engineHours = b.engineHours;
        this.engineHourOffset = b.engineHourOffset;
        this.licensePlate = b.licensePlate;
        this.licenseState = b.licenseState;
        this.pinDevice = b.pinDevice;
        this.disableSleeperBerth = b.disableSleeperBerth;
        this.autoHos = b.autoHos;
        this.fuelTankCapacity = b.fuelTankCapacity;
    }

    @Generated
    public static CustomVehicleDeviceBuilder<?, ?> customVehicleDeviceBuilder() {
        return new CustomVehicleDeviceBuilderImpl();
    }

    @Override
    @Generated
    public String getVehicleIdentificationNumber() {
        return this.vehicleIdentificationNumber;
    }

    @Override
    @Generated
    public String getEngineVehicleIdentificationNumber() {
        return this.engineVehicleIdentificationNumber;
    }

    @Generated
    public Double getOdometer() {
        return this.odometer;
    }

    @Override
    @Generated
    public Float getOdometerFactor() {
        return this.odometerFactor;
    }

    @Override
    @Generated
    public Double getOdometerOffset() {
        return this.odometerOffset;
    }

    @Generated
    public Double getEngineHours() {
        return this.engineHours;
    }

    @Override
    @Generated
    public Integer getEngineHourOffset() {
        return this.engineHourOffset;
    }

    @Override
    @Generated
    public String getLicensePlate() {
        return this.licensePlate;
    }

    @Override
    @Generated
    public String getLicenseState() {
        return this.licenseState;
    }

    @Generated
    public Boolean getPinDevice() {
        return this.pinDevice;
    }

    @Generated
    public Boolean getDisableSleeperBerth() {
        return this.disableSleeperBerth;
    }

    @Generated
    public HosOption getAutoHos() {
        return this.autoHos;
    }

    @Generated
    public Double getFuelTankCapacity() {
        return this.fuelTankCapacity;
    }

    @Override
    @Generated
    public CustomVehicleDevice setVehicleIdentificationNumber(String vehicleIdentificationNumber) {
        this.vehicleIdentificationNumber = vehicleIdentificationNumber;
        return this;
    }

    @Override
    @Generated
    public CustomVehicleDevice setEngineVehicleIdentificationNumber(String engineVehicleIdentificationNumber) {
        this.engineVehicleIdentificationNumber = engineVehicleIdentificationNumber;
        return this;
    }

    @Generated
    public CustomVehicleDevice setOdometer(Double odometer) {
        this.odometer = odometer;
        return this;
    }

    @Override
    @Generated
    public CustomVehicleDevice setOdometerFactor(Float odometerFactor) {
        this.odometerFactor = odometerFactor;
        return this;
    }

    @Override
    @Generated
    public CustomVehicleDevice setOdometerOffset(Double odometerOffset) {
        this.odometerOffset = odometerOffset;
        return this;
    }

    @Generated
    public CustomVehicleDevice setEngineHours(Double engineHours) {
        this.engineHours = engineHours;
        return this;
    }

    @Override
    @Generated
    public CustomVehicleDevice setEngineHourOffset(Integer engineHourOffset) {
        this.engineHourOffset = engineHourOffset;
        return this;
    }

    @Override
    @Generated
    public CustomVehicleDevice setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
        return this;
    }

    @Override
    @Generated
    public CustomVehicleDevice setLicenseState(String licenseState) {
        this.licenseState = licenseState;
        return this;
    }

    @Override
    @JsonProperty(value="pinDevice")
    @Generated
    public CustomVehicleDevice setPinDevice(Boolean pinDevice) {
        this.pinDevice = pinDevice;
        return this;
    }

    @Generated
    public CustomVehicleDevice setDisableSleeperBerth(Boolean disableSleeperBerth) {
        this.disableSleeperBerth = disableSleeperBerth;
        return this;
    }

    @Generated
    public CustomVehicleDevice setAutoHos(HosOption autoHos) {
        this.autoHos = autoHos;
        return this;
    }

    @Generated
    public CustomVehicleDevice setFuelTankCapacity(Double fuelTankCapacity) {
        this.fuelTankCapacity = fuelTankCapacity;
        return this;
    }

    @Generated
    public CustomVehicleDevice() {
        this.setDeviceType(DeviceType.CUSTOM_VEHICLE_DEVICE);
    }

    @Generated
    public static abstract class CustomVehicleDeviceBuilder<C extends CustomVehicleDevice, B extends CustomVehicleDeviceBuilder<C, B>>
    extends CustomDevice.CustomDeviceBuilder<C, B> {
        @Generated
        private String vehicleIdentificationNumber;
        @Generated
        private String engineVehicleIdentificationNumber;
        @Generated
        private Double odometer;
        @Generated
        private Float odometerFactor;
        @Generated
        private Double odometerOffset;
        @Generated
        private Double engineHours;
        @Generated
        private Integer engineHourOffset;
        @Generated
        private String licensePlate;
        @Generated
        private String licenseState;
        @Generated
        private Boolean pinDevice;
        @Generated
        private Boolean disableSleeperBerth;
        @Generated
        private HosOption autoHos;
        @Generated
        private Double fuelTankCapacity;

        @Generated
        public B vehicleIdentificationNumber(String vehicleIdentificationNumber) {
            this.vehicleIdentificationNumber = vehicleIdentificationNumber;
            return (B)((Object)this.self());
        }

        @Generated
        public B engineVehicleIdentificationNumber(String engineVehicleIdentificationNumber) {
            this.engineVehicleIdentificationNumber = engineVehicleIdentificationNumber;
            return (B)((Object)this.self());
        }

        @Generated
        public B odometer(Double odometer) {
            this.odometer = odometer;
            return (B)((Object)this.self());
        }

        @Generated
        public B odometerFactor(Float odometerFactor) {
            this.odometerFactor = odometerFactor;
            return (B)((Object)this.self());
        }

        @Generated
        public B odometerOffset(Double odometerOffset) {
            this.odometerOffset = odometerOffset;
            return (B)((Object)this.self());
        }

        @Generated
        public B engineHours(Double engineHours) {
            this.engineHours = engineHours;
            return (B)((Object)this.self());
        }

        @Generated
        public B engineHourOffset(Integer engineHourOffset) {
            this.engineHourOffset = engineHourOffset;
            return (B)((Object)this.self());
        }

        @Generated
        public B licensePlate(String licensePlate) {
            this.licensePlate = licensePlate;
            return (B)((Object)this.self());
        }

        @Generated
        public B licenseState(String licenseState) {
            this.licenseState = licenseState;
            return (B)((Object)this.self());
        }

        @JsonProperty(value="pinDevice")
        @Generated
        public B pinDevice(Boolean pinDevice) {
            this.pinDevice = pinDevice;
            return (B)((Object)this.self());
        }

        @Generated
        public B disableSleeperBerth(Boolean disableSleeperBerth) {
            this.disableSleeperBerth = disableSleeperBerth;
            return (B)((Object)this.self());
        }

        @Generated
        public B autoHos(HosOption autoHos) {
            this.autoHos = autoHos;
            return (B)((Object)this.self());
        }

        @Generated
        public B fuelTankCapacity(Double fuelTankCapacity) {
            this.fuelTankCapacity = fuelTankCapacity;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CustomVehicleDevice.CustomVehicleDeviceBuilder(super=" + super.toString() + ", vehicleIdentificationNumber=" + this.vehicleIdentificationNumber + ", engineVehicleIdentificationNumber=" + this.engineVehicleIdentificationNumber + ", odometer=" + this.odometer + ", odometerFactor=" + this.odometerFactor + ", odometerOffset=" + this.odometerOffset + ", engineHours=" + this.engineHours + ", engineHourOffset=" + this.engineHourOffset + ", licensePlate=" + this.licensePlate + ", licenseState=" + this.licenseState + ", pinDevice=" + this.pinDevice + ", disableSleeperBerth=" + this.disableSleeperBerth + ", autoHos=" + String.valueOf((Object)this.autoHos) + ", fuelTankCapacity=" + this.fuelTankCapacity + ")";
        }
    }

    @Generated
    private static final class CustomVehicleDeviceBuilderImpl
    extends CustomVehicleDeviceBuilder<CustomVehicleDevice, CustomVehicleDeviceBuilderImpl> {
        @Generated
        private CustomVehicleDeviceBuilderImpl() {
        }

        @Override
        @Generated
        protected CustomVehicleDeviceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CustomVehicleDevice build() {
            return new CustomVehicleDevice(this);
        }
    }
}

