/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.device;

import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.entity.device.A1;
import com.geotab.model.entity.device.CustomDevice;
import com.geotab.model.entity.device.CustomVehicleDevice;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.device.Go10;
import com.geotab.model.entity.device.Go4v3;
import com.geotab.model.entity.device.Go5;
import com.geotab.model.entity.device.Go6;
import com.geotab.model.entity.device.Go7;
import com.geotab.model.entity.device.Go8;
import com.geotab.model.entity.device.Go9;
import com.geotab.model.entity.device.Go9b;
import com.geotab.model.entity.device.GoAnywhere;
import com.geotab.model.entity.device.GoDriveDevice;
import com.geotab.model.entity.device.GoLegacy;
import com.geotab.model.entity.device.S1;
import com.geotab.model.entity.device.U1;
import com.geotab.model.entity.device.UntrackedAsset;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DeviceType implements HasName
{
    NONE("None", "", -1, UntrackedAsset.class, UntrackedAsset::new),
    OLD_GEOTAB("OldGeotab", "GT", 0, GoLegacy.class, GoLegacy::new),
    GO2("GO2", "GT", 1, GoLegacy.class, GoLegacy::new),
    GO3("GO3", "G3", 64, GoLegacy.class, GoLegacy::new),
    GO4("GO4", "G4", 65, GoLegacy.class, GoLegacy::new),
    GO4V3("GO4v3", "GV", 81, Go4v3.class, Go4v3::new),
    GO5("GO5", "G5", 90, Go5.class, Go5::new),
    GO6("GO6", "G6", 101, Go6.class, Go6::new),
    GO7("GO7", "G7", 105, Go7.class, Go7::new),
    GO8("GO8", "G8", 114, Go8.class, Go8::new),
    GO9("GO9", "G9", 120, Go9.class, Go9::new),
    GO9B("GO9B", "GA", 124, Go9b.class, Go9b::new),
    GO10("GO10", "GA", 124, Go10.class, Go10::new),
    CUSTOM_DEVICE("CustomDevice", "", 10000, CustomDevice.class, CustomDevice::new),
    GO_DRIVE_DEVICE("GoDriveDevice", "GD", 256, GoDriveDevice.class, GoDriveDevice::new),
    CUSTOM_VEHICLE_DEVICE("CustomVehicleDevice", "", 0, CustomVehicleDevice.class, CustomVehicleDevice::new),
    A1("A1", "A1", 255, A1.class, A1::new),
    U1("U1", "U1", 130, U1.class, U1::new),
    GoAnywhere("GoAnywhere", "B1", 131, GoAnywhere.class, GoAnywhere::new),
    S1("S1", "S1", 132, S1.class, S1::new);

    @Generated
    private static final Logger log;
    private final String name;
    private final String prefix;
    private final int productId;
    private final Class<? extends Device> type;
    private final Supplier<Device> constructor;

    private DeviceType(String name, String prefix, int productId, Class<? extends Device> type, Supplier<Device> constructor) {
        this.name = name;
        this.prefix = prefix;
        this.productId = productId;
        this.type = type;
        this.constructor = constructor;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getProductId() {
        return this.productId;
    }

    public Class<? extends Device> getType() {
        return this.type;
    }

    public Device newInstance() {
        return this.constructor.get();
    }

    public static DeviceType findOrDefault(String name) {
        if (Util.isEmpty((String)name)) {
            log.warn("Empty value is not recognized for {} enum; returning default {}", (Object)DeviceType.class.getSimpleName(), (Object)NONE);
            return NONE;
        }
        DeviceType deviceType = DeviceType.findByName(name);
        if (deviceType != null) {
            return deviceType;
        }
        log.warn("{} is not recognized for {} enum; returning default {}", new Object[]{name, DeviceType.class.getSimpleName(), NONE});
        return NONE;
    }

    public static DeviceType findByName(String name) {
        if (Util.isEmpty((String)name)) {
            return null;
        }
        for (DeviceType deviceType : DeviceType.values()) {
            if (!deviceType.getName().equalsIgnoreCase(name.trim())) continue;
            return deviceType;
        }
        return null;
    }

    static {
        log = LoggerFactory.getLogger(DeviceType.class);
    }
}

