/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.device;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.CustomParameter;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.device.DeviceType;
import com.geotab.model.entity.device.GoTalkLanguage;
import com.geotab.model.entity.device.HosOption;
import com.geotab.model.entity.device.LicensableAware;
import com.geotab.model.entity.device.VehicleIdentificationNumberAware;
import com.geotab.model.entity.enginetype.EngineType;
import com.geotab.model.entity.group.Group;
import com.geotab.model.serialization.serdes.EntityCollectionAsIdCollectionSerializer;
import com.geotab.model.wifi.WifiUsageTier;
import com.geotab.util.DeviceDefaultsUtil;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public abstract class GoDevice
extends Device
implements VehicleIdentificationNumberAware,
LicensableAware {
    @JsonSerialize(converter=EntityCollectionAsIdCollectionSerializer.class)
    protected List<Group> autoGroups;
    private List<CustomParameter> customParameters;
    private boolean disableBuzzer;
    private boolean enableBeepOnIdle;
    private boolean enableMustReprogram;
    private boolean enableSpeedWarning;
    private EngineType engineType;
    private String engineVehicleIdentificationNumber;
    private boolean ensureHotStart;
    private Integer gpsOffDelay;
    private Integer idleMinutes;
    private Boolean isSpeedIndicator;
    private String licensePlate;
    private String licenseState;
    private Short major;
    private Double minAccidentSpeed;
    private Short minor;
    private Integer parameterVersion;
    private Boolean pinDevice;
    private Double speedingOff;
    private Double speedingOn;
    private String vehicleIdentificationNumber;
    private GoTalkLanguage goTalkLanguage;
    private Double fuelTankCapacity;
    private Boolean disableSleeperBerth;
    private HosOption autoHos;
    private List<WifiUsageTier> wifiHotspotLimits;
    private Short parameterVersionOnDevice;

    @Override
    public Boolean isPinDevice() {
        return this.getPinDevice();
    }

    @JsonIgnore
    public Boolean isExternalDevicePowerControlSupported() {
        if (this.deviceType == null || this.productId == null) {
            return null;
        }
        return this.deviceType == DeviceType.GO9 || this.deviceType == DeviceType.GO9B || this.deviceType == DeviceType.GO8 || this.deviceType == DeviceType.GO7 || this.deviceType == DeviceType.GO6 || this.deviceType == DeviceType.GO4V3 || this.productId == 66 || this.productId >= 78 && this.productId <= 80;
    }

    public static int byteToDegrees(short value) {
        return (int)Math.round(2.403 * (double)value);
    }

    public static double byteToSpeed(short value) {
        return (double)value * 3.6 * 0.512;
    }

    public static boolean[] checkAndPadAuxArray(boolean[] booleanArray) {
        if (booleanArray == null) {
            return new boolean[8];
        }
        if (booleanArray.length > 8) {
            throw new IllegalArgumentException("booleanArray.length cannot be more then 8");
        }
        return Arrays.copyOf(booleanArray, 8);
    }

    public static double[] checkAndPadAuxArray(double[] doubleArray) {
        if (doubleArray == null) {
            return new double[8];
        }
        if (doubleArray.length > 8) {
            throw new IllegalArgumentException("doubleArray.length cannot be more then 8");
        }
        return Arrays.copyOf(doubleArray, 8);
    }

    public static boolean[] checkAndPadAuxIgnArray(boolean[] booleanArray) {
        if (booleanArray == null) {
            return new boolean[4];
        }
        if (booleanArray.length > 4) {
            throw new IllegalArgumentException("booleanArray.Length cannot be more then 4");
        }
        return Arrays.copyOf(booleanArray, 4);
    }

    public static short[] checkAndPadChannelArray(short[] shortArray) {
        if (shortArray == null) {
            return new short[20];
        }
        if (shortArray.length > 20) {
            throw new IllegalArgumentException("shortArray.length cannot be more then 20");
        }
        return Arrays.copyOf(shortArray, 20);
    }

    public static short degreesToByte(int value) {
        return (short)Math.round((double)value / 2.403);
    }

    public static short speedToByte(double value) {
        return (short)Math.round(value / 3.6 / 0.512);
    }

    @JsonIgnore
    public Boolean isGarminSupported() {
        if (this.deviceType == null || this.productId == null) {
            return null;
        }
        return this.deviceType == DeviceType.GO9 || this.deviceType == DeviceType.GO9B || this.deviceType == DeviceType.GO8 || this.deviceType == DeviceType.GO7 || this.deviceType == DeviceType.GO6 || this.deviceType == DeviceType.GO4V3 || this.productId == 66 || this.productId == 80;
    }

    @JsonIgnore
    public Boolean isRFDevice() {
        if (this.productId == null) {
            return null;
        }
        switch (this.productId) {
            case 3: 
            case 5: 
            case 10: 
            case 12: 
            case 14: 
            case 32: 
            case 36: 
            case 38: 
            case 39: 
            case 68: 
            case 69: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 82: 
            case 84: {
                return true;
            }
            case 17: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 30: 
            case 34: 
            case 35: 
            case 37: 
            case 65: 
            case 66: 
            case 67: 
            case 71: 
            case 72: 
            case 73: 
            case 79: 
            case 80: 
            case 81: 
            case 83: {
                return false;
            }
        }
        return this.deviceType == DeviceType.GO5 || this.deviceType == DeviceType.GO6 || this.deviceType == DeviceType.GO7 || this.deviceType == DeviceType.GO8 || this.deviceType == DeviceType.GO9 || this.deviceType == DeviceType.GO9B || this.deviceType == DeviceType.CUSTOM_DEVICE || this.deviceType == DeviceType.CUSTOM_VEHICLE_DEVICE || this.deviceType == DeviceType.GO_DRIVE_DEVICE ? Boolean.valueOf(false) : null;
    }

    @Override
    public void populateDefaults() {
        super.populateDefaults();
        DeviceDefaultsUtil.addVehicleIdentificationNumberDefaults(this);
        DeviceDefaultsUtil.addGoDeviceDefaults(this);
    }

    @Generated
    protected GoDevice(GoDeviceBuilder<?, ?> b) {
        super(b);
        this.autoGroups = b.autoGroups;
        this.customParameters = b.customParameters;
        this.disableBuzzer = b.disableBuzzer;
        this.enableBeepOnIdle = b.enableBeepOnIdle;
        this.enableMustReprogram = b.enableMustReprogram;
        this.enableSpeedWarning = b.enableSpeedWarning;
        this.engineType = b.engineType;
        this.engineVehicleIdentificationNumber = b.engineVehicleIdentificationNumber;
        this.ensureHotStart = b.ensureHotStart;
        this.gpsOffDelay = b.gpsOffDelay;
        this.idleMinutes = b.idleMinutes;
        this.isSpeedIndicator = b.isSpeedIndicator;
        this.licensePlate = b.licensePlate;
        this.licenseState = b.licenseState;
        this.major = b.major;
        this.minAccidentSpeed = b.minAccidentSpeed;
        this.minor = b.minor;
        this.parameterVersion = b.parameterVersion;
        this.pinDevice = b.pinDevice;
        this.speedingOff = b.speedingOff;
        this.speedingOn = b.speedingOn;
        this.vehicleIdentificationNumber = b.vehicleIdentificationNumber;
        this.goTalkLanguage = b.goTalkLanguage;
        this.fuelTankCapacity = b.fuelTankCapacity;
        this.disableSleeperBerth = b.disableSleeperBerth;
        this.autoHos = b.autoHos;
        this.wifiHotspotLimits = b.wifiHotspotLimits;
        this.parameterVersionOnDevice = b.parameterVersionOnDevice;
    }

    @Generated
    public List<Group> getAutoGroups() {
        return this.autoGroups;
    }

    @Generated
    public List<CustomParameter> getCustomParameters() {
        return this.customParameters;
    }

    @Generated
    public boolean getDisableBuzzer() {
        return this.disableBuzzer;
    }

    @Generated
    public boolean getEnableBeepOnIdle() {
        return this.enableBeepOnIdle;
    }

    @Generated
    public boolean getEnableMustReprogram() {
        return this.enableMustReprogram;
    }

    @Generated
    public boolean getEnableSpeedWarning() {
        return this.enableSpeedWarning;
    }

    @Generated
    public EngineType getEngineType() {
        return this.engineType;
    }

    @Override
    @Generated
    public String getEngineVehicleIdentificationNumber() {
        return this.engineVehicleIdentificationNumber;
    }

    @Generated
    public boolean getEnsureHotStart() {
        return this.ensureHotStart;
    }

    @Generated
    public Integer getGpsOffDelay() {
        return this.gpsOffDelay;
    }

    @Generated
    public Integer getIdleMinutes() {
        return this.idleMinutes;
    }

    @Generated
    public Boolean getIsSpeedIndicator() {
        return this.isSpeedIndicator;
    }

    @Override
    @Generated
    public String getLicensePlate() {
        return this.licensePlate;
    }

    @Override
    @Generated
    public String getLicenseState() {
        return this.licenseState;
    }

    @Generated
    public Short getMajor() {
        return this.major;
    }

    @Generated
    public Double getMinAccidentSpeed() {
        return this.minAccidentSpeed;
    }

    @Generated
    public Short getMinor() {
        return this.minor;
    }

    @Generated
    public Integer getParameterVersion() {
        return this.parameterVersion;
    }

    @Generated
    public Boolean getPinDevice() {
        return this.pinDevice;
    }

    @Generated
    public Double getSpeedingOff() {
        return this.speedingOff;
    }

    @Generated
    public Double getSpeedingOn() {
        return this.speedingOn;
    }

    @Override
    @Generated
    public String getVehicleIdentificationNumber() {
        return this.vehicleIdentificationNumber;
    }

    @Generated
    public GoTalkLanguage getGoTalkLanguage() {
        return this.goTalkLanguage;
    }

    @Generated
    public Double getFuelTankCapacity() {
        return this.fuelTankCapacity;
    }

    @Generated
    public Boolean getDisableSleeperBerth() {
        return this.disableSleeperBerth;
    }

    @Generated
    public HosOption getAutoHos() {
        return this.autoHos;
    }

    @Generated
    public List<WifiUsageTier> getWifiHotspotLimits() {
        return this.wifiHotspotLimits;
    }

    @Generated
    public Short getParameterVersionOnDevice() {
        return this.parameterVersionOnDevice;
    }

    @Generated
    public GoDevice setAutoGroups(List<Group> autoGroups) {
        this.autoGroups = autoGroups;
        return this;
    }

    @Generated
    public GoDevice setCustomParameters(List<CustomParameter> customParameters) {
        this.customParameters = customParameters;
        return this;
    }

    @Generated
    public GoDevice setDisableBuzzer(boolean disableBuzzer) {
        this.disableBuzzer = disableBuzzer;
        return this;
    }

    @Generated
    public GoDevice setEnableBeepOnIdle(boolean enableBeepOnIdle) {
        this.enableBeepOnIdle = enableBeepOnIdle;
        return this;
    }

    @Generated
    public GoDevice setEnableMustReprogram(boolean enableMustReprogram) {
        this.enableMustReprogram = enableMustReprogram;
        return this;
    }

    @Generated
    public GoDevice setEnableSpeedWarning(boolean enableSpeedWarning) {
        this.enableSpeedWarning = enableSpeedWarning;
        return this;
    }

    @Generated
    public GoDevice setEngineType(EngineType engineType) {
        this.engineType = engineType;
        return this;
    }

    @Override
    @Generated
    public GoDevice setEngineVehicleIdentificationNumber(String engineVehicleIdentificationNumber) {
        this.engineVehicleIdentificationNumber = engineVehicleIdentificationNumber;
        return this;
    }

    @Generated
    public GoDevice setEnsureHotStart(boolean ensureHotStart) {
        this.ensureHotStart = ensureHotStart;
        return this;
    }

    @Generated
    public GoDevice setGpsOffDelay(Integer gpsOffDelay) {
        this.gpsOffDelay = gpsOffDelay;
        return this;
    }

    @Generated
    public GoDevice setIdleMinutes(Integer idleMinutes) {
        this.idleMinutes = idleMinutes;
        return this;
    }

    @Generated
    public GoDevice setIsSpeedIndicator(Boolean isSpeedIndicator) {
        this.isSpeedIndicator = isSpeedIndicator;
        return this;
    }

    @Override
    @Generated
    public GoDevice setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
        return this;
    }

    @Override
    @Generated
    public GoDevice setLicenseState(String licenseState) {
        this.licenseState = licenseState;
        return this;
    }

    @Generated
    public GoDevice setMajor(Short major) {
        this.major = major;
        return this;
    }

    @Generated
    public GoDevice setMinAccidentSpeed(Double minAccidentSpeed) {
        this.minAccidentSpeed = minAccidentSpeed;
        return this;
    }

    @Generated
    public GoDevice setMinor(Short minor) {
        this.minor = minor;
        return this;
    }

    @Generated
    public GoDevice setParameterVersion(Integer parameterVersion) {
        this.parameterVersion = parameterVersion;
        return this;
    }

    @Override
    @Generated
    public GoDevice setPinDevice(Boolean pinDevice) {
        this.pinDevice = pinDevice;
        return this;
    }

    @Generated
    public GoDevice setSpeedingOff(Double speedingOff) {
        this.speedingOff = speedingOff;
        return this;
    }

    @Generated
    public GoDevice setSpeedingOn(Double speedingOn) {
        this.speedingOn = speedingOn;
        return this;
    }

    @Override
    @Generated
    public GoDevice setVehicleIdentificationNumber(String vehicleIdentificationNumber) {
        this.vehicleIdentificationNumber = vehicleIdentificationNumber;
        return this;
    }

    @Generated
    public GoDevice setGoTalkLanguage(GoTalkLanguage goTalkLanguage) {
        this.goTalkLanguage = goTalkLanguage;
        return this;
    }

    @Generated
    public GoDevice setFuelTankCapacity(Double fuelTankCapacity) {
        this.fuelTankCapacity = fuelTankCapacity;
        return this;
    }

    @Generated
    public GoDevice setDisableSleeperBerth(Boolean disableSleeperBerth) {
        this.disableSleeperBerth = disableSleeperBerth;
        return this;
    }

    @Generated
    public GoDevice setAutoHos(HosOption autoHos) {
        this.autoHos = autoHos;
        return this;
    }

    @Generated
    public GoDevice setWifiHotspotLimits(List<WifiUsageTier> wifiHotspotLimits) {
        this.wifiHotspotLimits = wifiHotspotLimits;
        return this;
    }

    @Generated
    public GoDevice setParameterVersionOnDevice(Short parameterVersionOnDevice) {
        this.parameterVersionOnDevice = parameterVersionOnDevice;
        return this;
    }

    @Generated
    public GoDevice() {
    }

    @Generated
    public static abstract class GoDeviceBuilder<C extends GoDevice, B extends GoDeviceBuilder<C, B>>
    extends Device.DeviceBuilder<C, B> {
        @Generated
        private List<Group> autoGroups;
        @Generated
        private List<CustomParameter> customParameters;
        @Generated
        private boolean disableBuzzer;
        @Generated
        private boolean enableBeepOnIdle;
        @Generated
        private boolean enableMustReprogram;
        @Generated
        private boolean enableSpeedWarning;
        @Generated
        private EngineType engineType;
        @Generated
        private String engineVehicleIdentificationNumber;
        @Generated
        private boolean ensureHotStart;
        @Generated
        private Integer gpsOffDelay;
        @Generated
        private Integer idleMinutes;
        @Generated
        private Boolean isSpeedIndicator;
        @Generated
        private String licensePlate;
        @Generated
        private String licenseState;
        @Generated
        private Short major;
        @Generated
        private Double minAccidentSpeed;
        @Generated
        private Short minor;
        @Generated
        private Integer parameterVersion;
        @Generated
        private Boolean pinDevice;
        @Generated
        private Double speedingOff;
        @Generated
        private Double speedingOn;
        @Generated
        private String vehicleIdentificationNumber;
        @Generated
        private GoTalkLanguage goTalkLanguage;
        @Generated
        private Double fuelTankCapacity;
        @Generated
        private Boolean disableSleeperBerth;
        @Generated
        private HosOption autoHos;
        @Generated
        private List<WifiUsageTier> wifiHotspotLimits;
        @Generated
        private Short parameterVersionOnDevice;

        @Generated
        public B autoGroups(List<Group> autoGroups) {
            this.autoGroups = autoGroups;
            return (B)((Object)this.self());
        }

        @Generated
        public B customParameters(List<CustomParameter> customParameters) {
            this.customParameters = customParameters;
            return (B)((Object)this.self());
        }

        @Generated
        public B disableBuzzer(boolean disableBuzzer) {
            this.disableBuzzer = disableBuzzer;
            return (B)((Object)this.self());
        }

        @Generated
        public B enableBeepOnIdle(boolean enableBeepOnIdle) {
            this.enableBeepOnIdle = enableBeepOnIdle;
            return (B)((Object)this.self());
        }

        @Generated
        public B enableMustReprogram(boolean enableMustReprogram) {
            this.enableMustReprogram = enableMustReprogram;
            return (B)((Object)this.self());
        }

        @Generated
        public B enableSpeedWarning(boolean enableSpeedWarning) {
            this.enableSpeedWarning = enableSpeedWarning;
            return (B)((Object)this.self());
        }

        @Generated
        public B engineType(EngineType engineType) {
            this.engineType = engineType;
            return (B)((Object)this.self());
        }

        @Generated
        public B engineVehicleIdentificationNumber(String engineVehicleIdentificationNumber) {
            this.engineVehicleIdentificationNumber = engineVehicleIdentificationNumber;
            return (B)((Object)this.self());
        }

        @Generated
        public B ensureHotStart(boolean ensureHotStart) {
            this.ensureHotStart = ensureHotStart;
            return (B)((Object)this.self());
        }

        @Generated
        public B gpsOffDelay(Integer gpsOffDelay) {
            this.gpsOffDelay = gpsOffDelay;
            return (B)((Object)this.self());
        }

        @Generated
        public B idleMinutes(Integer idleMinutes) {
            this.idleMinutes = idleMinutes;
            return (B)((Object)this.self());
        }

        @Generated
        public B isSpeedIndicator(Boolean isSpeedIndicator) {
            this.isSpeedIndicator = isSpeedIndicator;
            return (B)((Object)this.self());
        }

        @Generated
        public B licensePlate(String licensePlate) {
            this.licensePlate = licensePlate;
            return (B)((Object)this.self());
        }

        @Generated
        public B licenseState(String licenseState) {
            this.licenseState = licenseState;
            return (B)((Object)this.self());
        }

        @Generated
        public B major(Short major) {
            this.major = major;
            return (B)((Object)this.self());
        }

        @Generated
        public B minAccidentSpeed(Double minAccidentSpeed) {
            this.minAccidentSpeed = minAccidentSpeed;
            return (B)((Object)this.self());
        }

        @Generated
        public B minor(Short minor) {
            this.minor = minor;
            return (B)((Object)this.self());
        }

        @Generated
        public B parameterVersion(Integer parameterVersion) {
            this.parameterVersion = parameterVersion;
            return (B)((Object)this.self());
        }

        @Generated
        public B pinDevice(Boolean pinDevice) {
            this.pinDevice = pinDevice;
            return (B)((Object)this.self());
        }

        @Generated
        public B speedingOff(Double speedingOff) {
            this.speedingOff = speedingOff;
            return (B)((Object)this.self());
        }

        @Generated
        public B speedingOn(Double speedingOn) {
            this.speedingOn = speedingOn;
            return (B)((Object)this.self());
        }

        @Generated
        public B vehicleIdentificationNumber(String vehicleIdentificationNumber) {
            this.vehicleIdentificationNumber = vehicleIdentificationNumber;
            return (B)((Object)this.self());
        }

        @Generated
        public B goTalkLanguage(GoTalkLanguage goTalkLanguage) {
            this.goTalkLanguage = goTalkLanguage;
            return (B)((Object)this.self());
        }

        @Generated
        public B fuelTankCapacity(Double fuelTankCapacity) {
            this.fuelTankCapacity = fuelTankCapacity;
            return (B)((Object)this.self());
        }

        @Generated
        public B disableSleeperBerth(Boolean disableSleeperBerth) {
            this.disableSleeperBerth = disableSleeperBerth;
            return (B)((Object)this.self());
        }

        @Generated
        public B autoHos(HosOption autoHos) {
            this.autoHos = autoHos;
            return (B)((Object)this.self());
        }

        @Generated
        public B wifiHotspotLimits(List<WifiUsageTier> wifiHotspotLimits) {
            this.wifiHotspotLimits = wifiHotspotLimits;
            return (B)((Object)this.self());
        }

        @Generated
        public B parameterVersionOnDevice(Short parameterVersionOnDevice) {
            this.parameterVersionOnDevice = parameterVersionOnDevice;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "GoDevice.GoDeviceBuilder(super=" + super.toString() + ", autoGroups=" + String.valueOf(this.autoGroups) + ", customParameters=" + String.valueOf(this.customParameters) + ", disableBuzzer=" + this.disableBuzzer + ", enableBeepOnIdle=" + this.enableBeepOnIdle + ", enableMustReprogram=" + this.enableMustReprogram + ", enableSpeedWarning=" + this.enableSpeedWarning + ", engineType=" + String.valueOf((Object)this.engineType) + ", engineVehicleIdentificationNumber=" + this.engineVehicleIdentificationNumber + ", ensureHotStart=" + this.ensureHotStart + ", gpsOffDelay=" + this.gpsOffDelay + ", idleMinutes=" + this.idleMinutes + ", isSpeedIndicator=" + this.isSpeedIndicator + ", licensePlate=" + this.licensePlate + ", licenseState=" + this.licenseState + ", major=" + this.major + ", minAccidentSpeed=" + this.minAccidentSpeed + ", minor=" + this.minor + ", parameterVersion=" + this.parameterVersion + ", pinDevice=" + this.pinDevice + ", speedingOff=" + this.speedingOff + ", speedingOn=" + this.speedingOn + ", vehicleIdentificationNumber=" + this.vehicleIdentificationNumber + ", goTalkLanguage=" + String.valueOf((Object)this.goTalkLanguage) + ", fuelTankCapacity=" + this.fuelTankCapacity + ", disableSleeperBerth=" + this.disableSleeperBerth + ", autoHos=" + String.valueOf((Object)this.autoHos) + ", wifiHotspotLimits=" + String.valueOf(this.wifiHotspotLimits) + ", parameterVersionOnDevice=" + this.parameterVersionOnDevice + ")";
        }
    }
}

