/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.file;

import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MediaType implements HasName
{
    UNKNOWN("Unknown", 0),
    VIDEO("Video", 1),
    IMAGE("Image", 2),
    APPLICATION("Application", 3),
    BINARY_DATA("BinaryData", 4);

    @Generated
    private static final Logger log;
    private final String name;
    private final int code;

    private MediaType(String name, int code) {
        this.name = name;
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public static MediaType findOrDefault(String name) {
        if (Util.isEmpty((String)name)) {
            log.warn("Empty value is not recognized for {} enum; returning default {}", (Object)MediaType.class.getSimpleName(), (Object)UNKNOWN);
            return UNKNOWN;
        }
        for (MediaType mediaType : MediaType.values()) {
            if (!mediaType.getName().equalsIgnoreCase(name.trim())) continue;
            return mediaType;
        }
        log.warn("{} is not recognized for {} enum; returning default {}", new Object[]{name, MediaType.class.getSimpleName(), UNKNOWN});
        return UNKNOWN;
    }

    static {
        log = LoggerFactory.getLogger(MediaType.class);
    }
}

