/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.logrecord;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.geotab.model.coordinate.Coordinate;
import com.geotab.model.entity.Entity;
import com.geotab.model.entity.device.Device;
import com.geotab.util.LogRecordValidator;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;

public class LogRecord
extends Entity {
    private Double latitude;
    private Double longitude;
    private Float speed;
    private Device device;
    private LocalDateTime dateTime;

    public static double distanceBetweenPoints(double longitudeA, double latitudeA, double longitudeB, double latitudeB) {
        return Coordinate.distanceBetween(longitudeA, latitudeA, longitudeB, latitudeB) / 1000.0;
    }

    public static List<Coordinate> getExtent(List<LogRecord> logRecords) {
        double xMin = Double.MAX_VALUE;
        double xMax = Double.MIN_VALUE;
        double yMin = Double.MAX_VALUE;
        double yMax = Double.MIN_VALUE;
        for (LogRecord log : logRecords) {
            double x = log.longitude;
            double y = log.latitude;
            if (xMin != Double.MAX_VALUE) {
                if (xMin > x) {
                    if (!LogRecordValidator.isValidCoordinateRange(x, y)) continue;
                    xMin = x;
                } else if (xMax < x) {
                    if (!LogRecordValidator.isValidCoordinateRange(x, y)) continue;
                    xMax = x;
                }
                if (yMin > y) {
                    if (!LogRecordValidator.isValidCoordinateRange(x, y)) continue;
                    yMin = y;
                    continue;
                }
                if (!(yMax < y) || !LogRecordValidator.isValidCoordinateRange(x, y)) continue;
                yMax = y;
                continue;
            }
            if (!LogRecordValidator.isValidCoordinateRange(x, y)) continue;
            xMax = xMin = x;
            yMax = yMin = y;
        }
        if (xMin == Double.MAX_VALUE) {
            return null;
        }
        return Coordinate.rectangleFromLtrb(xMin, yMax, xMax, yMin);
    }

    @JsonIgnore
    public double distanceTo(LogRecord logRecord) {
        return LogRecord.distanceBetweenPoints(this.longitude, this.latitude, logRecord.longitude, logRecord.latitude);
    }

    @JsonIgnore
    public double distanceTo(Coordinate coordinate) {
        return LogRecord.distanceBetweenPoints(this.longitude, this.latitude, coordinate.getX(), coordinate.getY());
    }

    @JsonIgnore
    public Coordinate toSimpleCoordinate() {
        if (this.longitude == null || this.latitude == null) {
            return null;
        }
        return new Coordinate(this.longitude, this.latitude);
    }

    @Generated
    protected LogRecord(LogRecordBuilder<?, ?> b) {
        super(b);
        this.latitude = b.latitude;
        this.longitude = b.longitude;
        this.speed = b.speed;
        this.device = b.device;
        this.dateTime = b.dateTime;
    }

    @Generated
    public static LogRecordBuilder<?, ?> builder() {
        return new LogRecordBuilderImpl();
    }

    @Generated
    public Double getLatitude() {
        return this.latitude;
    }

    @Generated
    public Double getLongitude() {
        return this.longitude;
    }

    @Generated
    public Float getSpeed() {
        return this.speed;
    }

    @Generated
    public Device getDevice() {
        return this.device;
    }

    @Generated
    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    @Generated
    public LogRecord setLatitude(Double latitude) {
        this.latitude = latitude;
        return this;
    }

    @Generated
    public LogRecord setLongitude(Double longitude) {
        this.longitude = longitude;
        return this;
    }

    @Generated
    public LogRecord setSpeed(Float speed) {
        this.speed = speed;
        return this;
    }

    @Generated
    public LogRecord setDevice(Device device) {
        this.device = device;
        return this;
    }

    @Generated
    public LogRecord setDateTime(LocalDateTime dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    @Generated
    public LogRecord() {
    }

    @Generated
    public static abstract class LogRecordBuilder<C extends LogRecord, B extends LogRecordBuilder<C, B>>
    extends Entity.EntityBuilder<C, B> {
        @Generated
        private Double latitude;
        @Generated
        private Double longitude;
        @Generated
        private Float speed;
        @Generated
        private Device device;
        @Generated
        private LocalDateTime dateTime;

        @Generated
        public B latitude(Double latitude) {
            this.latitude = latitude;
            return (B)this.self();
        }

        @Generated
        public B longitude(Double longitude) {
            this.longitude = longitude;
            return (B)this.self();
        }

        @Generated
        public B speed(Float speed) {
            this.speed = speed;
            return (B)this.self();
        }

        @Generated
        public B device(Device device) {
            this.device = device;
            return (B)this.self();
        }

        @Generated
        public B dateTime(LocalDateTime dateTime) {
            this.dateTime = dateTime;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "LogRecord.LogRecordBuilder(super=" + super.toString() + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", speed=" + this.speed + ", device=" + String.valueOf((Object)this.device) + ", dateTime=" + String.valueOf(this.dateTime) + ")";
        }
    }

    @Generated
    private static final class LogRecordBuilderImpl
    extends LogRecordBuilder<LogRecord, LogRecordBuilderImpl> {
        @Generated
        private LogRecordBuilderImpl() {
        }

        @Override
        @Generated
        protected LogRecordBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LogRecord build() {
            return new LogRecord(this);
        }
    }
}

