/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.rule;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.Id;
import com.geotab.model.drawing.Color;
import com.geotab.model.entity.NameEntityWithVersion;
import com.geotab.model.entity.condition.Condition;
import com.geotab.model.entity.group.Group;
import com.geotab.model.entity.rule.ExceptionRuleBaseType;
import com.geotab.model.entity.rule.NoRule;
import com.geotab.model.serialization.serdes.EntityCollectionAsIdCollectionSerializer;
import com.geotab.util.Util;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;

public class Rule
extends NameEntityWithVersion {
    private Condition condition;
    private LocalDateTime activeFrom;
    private LocalDateTime activeTo;
    private ExceptionRuleBaseType baseType;
    private Color color;
    private String comment;
    @JsonSerialize(converter=EntityCollectionAsIdCollectionSerializer.class)
    private List<Group> groups;

    public Rule(String id) {
        this.setId(new Id(id));
        this.setName(id);
    }

    public static Rule fromSystem(String id) {
        if (Util.isEmpty((String)id)) {
            return null;
        }
        if ("NoRuleId".equals(id)) {
            return NoRule.getInstance();
        }
        return null;
    }

    @Generated
    protected Rule(RuleBuilder<?, ?> b) {
        super(b);
        this.condition = b.condition;
        this.activeFrom = b.activeFrom;
        this.activeTo = b.activeTo;
        this.baseType = b.baseType;
        this.color = b.color;
        this.comment = b.comment;
        this.groups = b.groups;
    }

    @Generated
    public static RuleBuilder<?, ?> builder() {
        return new RuleBuilderImpl();
    }

    @Generated
    public Condition getCondition() {
        return this.condition;
    }

    @Generated
    public LocalDateTime getActiveFrom() {
        return this.activeFrom;
    }

    @Generated
    public LocalDateTime getActiveTo() {
        return this.activeTo;
    }

    @Generated
    public ExceptionRuleBaseType getBaseType() {
        return this.baseType;
    }

    @Generated
    public Color getColor() {
        return this.color;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public List<Group> getGroups() {
        return this.groups;
    }

    @Generated
    public Rule setCondition(Condition condition) {
        this.condition = condition;
        return this;
    }

    @Generated
    public Rule setActiveFrom(LocalDateTime activeFrom) {
        this.activeFrom = activeFrom;
        return this;
    }

    @Generated
    public Rule setActiveTo(LocalDateTime activeTo) {
        this.activeTo = activeTo;
        return this;
    }

    @Generated
    public Rule setBaseType(ExceptionRuleBaseType baseType) {
        this.baseType = baseType;
        return this;
    }

    @Generated
    public Rule setColor(Color color) {
        this.color = color;
        return this;
    }

    @Generated
    public Rule setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @Generated
    public Rule setGroups(List<Group> groups) {
        this.groups = groups;
        return this;
    }

    @Generated
    public Rule() {
    }

    @Generated
    public static abstract class RuleBuilder<C extends Rule, B extends RuleBuilder<C, B>>
    extends NameEntityWithVersion.NameEntityWithVersionBuilder<C, B> {
        @Generated
        private Condition condition;
        @Generated
        private LocalDateTime activeFrom;
        @Generated
        private LocalDateTime activeTo;
        @Generated
        private ExceptionRuleBaseType baseType;
        @Generated
        private Color color;
        @Generated
        private String comment;
        @Generated
        private List<Group> groups;

        @Generated
        public B condition(Condition condition) {
            this.condition = condition;
            return (B)this.self();
        }

        @Generated
        public B activeFrom(LocalDateTime activeFrom) {
            this.activeFrom = activeFrom;
            return (B)this.self();
        }

        @Generated
        public B activeTo(LocalDateTime activeTo) {
            this.activeTo = activeTo;
            return (B)this.self();
        }

        @Generated
        public B baseType(ExceptionRuleBaseType baseType) {
            this.baseType = baseType;
            return (B)this.self();
        }

        @Generated
        public B color(Color color) {
            this.color = color;
            return (B)this.self();
        }

        @Generated
        public B comment(String comment) {
            this.comment = comment;
            return (B)this.self();
        }

        @Generated
        public B groups(List<Group> groups) {
            this.groups = groups;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Rule.RuleBuilder(super=" + super.toString() + ", condition=" + String.valueOf((Object)this.condition) + ", activeFrom=" + String.valueOf(this.activeFrom) + ", activeTo=" + String.valueOf(this.activeTo) + ", baseType=" + String.valueOf((Object)this.baseType) + ", color=" + String.valueOf(this.color) + ", comment=" + this.comment + ", groups=" + String.valueOf(this.groups) + ")";
        }
    }

    @Generated
    private static final class RuleBuilderImpl
    extends RuleBuilder<Rule, RuleBuilderImpl> {
        @Generated
        private RuleBuilderImpl() {
        }

        @Override
        @Generated
        protected RuleBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Rule build() {
            return new Rule(this);
        }
    }
}

