/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.tachograph.files;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.Id;
import com.geotab.model.entity.EntityWithVersion;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.entitysettings.TachographFileFormat;
import com.geotab.model.entity.user.Driver;
import com.geotab.model.serialization.serdes.ByteArrayDeserializer;
import com.geotab.model.serialization.serdes.ByteArraySerializer;
import java.time.LocalDateTime;
import java.util.Arrays;
import lombok.Generated;

public class TachographDataFile
extends EntityWithVersion {
    private Driver driver;
    private Device device;
    @JsonDeserialize(using=ByteArrayDeserializer.class)
    @JsonSerialize(using=ByteArraySerializer.class)
    private Byte[] binaryData;
    private Integer origin;
    private String originDescription;
    private LocalDateTime dateTime;
    private LocalDateTime uploadDateTime;
    private LocalDateTime timestamp;
    private LocalDateTime timestampStart;
    private LocalDateTime timestampEnd;
    private String fileName;
    private String summary;
    private Integer signature;
    private String fileNameTgd;
    private String fileNameDdd;
    private String fileNameV1B;
    private String warnings;
    private String errors;
    private Integer processingStatus;
    private String lockGaps;
    private Boolean archived;

    public TachographDataFile(TachographDataFile value) {
        this(value.getId(), value.getDriver(), value.getDevice(), value.getBinaryData(), value.getOrigin(), value.getOriginDescription(), value.getDateTime(), value.getTimestamp(), value.getTimestampStart(), value.getTimestampEnd(), value.getFileName(), value.getSummary(), value.getSignature(), value.getFileNameTgd(), value.getFileNameDdd(), value.getFileNameV1B(), value.getWarnings(), value.getErrors(), value.getProcessingStatus(), value.getLockGaps(), value.getArchived());
    }

    public TachographDataFile(Id id, Driver driver, Device device, Byte[] binaryData, Integer origin, String originDescription, LocalDateTime dateTime, LocalDateTime timestamp, LocalDateTime timestampStart, LocalDateTime timestampEnd, String fileName, String summary, Integer signature, String fileNameTgd, String fileNameDdd, String fileNameV1B, String warnings, String errors, Integer processingStatus, String lockGaps, Boolean archived) {
        this.setId(id);
        this.driver = driver;
        this.device = device;
        this.binaryData = binaryData;
        this.origin = origin;
        this.originDescription = originDescription;
        this.dateTime = dateTime;
        this.timestamp = timestamp;
        this.timestampStart = timestampStart;
        this.timestampEnd = timestampEnd;
        this.fileName = fileName;
        this.summary = summary;
        this.signature = signature;
        this.fileNameTgd = fileNameTgd;
        this.fileNameDdd = fileNameDdd;
        this.fileNameV1B = fileNameV1B;
        this.warnings = warnings;
        this.errors = errors;
        this.processingStatus = processingStatus;
        this.lockGaps = lockGaps;
        this.archived = archived;
    }

    public String getFileNameFromFileFormatOrDefault(TachographFileFormat tachographFileFormat) {
        switch (tachographFileFormat) {
            case Ddd: {
                return this.fileNameDdd;
            }
            case V1b: {
                return this.fileNameV1B;
            }
        }
        return this.fileNameTgd;
    }

    @Generated
    protected TachographDataFile(TachographDataFileBuilder<?, ?> b) {
        super(b);
        this.driver = b.driver;
        this.device = b.device;
        this.binaryData = b.binaryData;
        this.origin = b.origin;
        this.originDescription = b.originDescription;
        this.dateTime = b.dateTime;
        this.uploadDateTime = b.uploadDateTime;
        this.timestamp = b.timestamp;
        this.timestampStart = b.timestampStart;
        this.timestampEnd = b.timestampEnd;
        this.fileName = b.fileName;
        this.summary = b.summary;
        this.signature = b.signature;
        this.fileNameTgd = b.fileNameTgd;
        this.fileNameDdd = b.fileNameDdd;
        this.fileNameV1B = b.fileNameV1B;
        this.warnings = b.warnings;
        this.errors = b.errors;
        this.processingStatus = b.processingStatus;
        this.lockGaps = b.lockGaps;
        this.archived = b.archived;
    }

    @Generated
    public static TachographDataFileBuilder<?, ?> builder() {
        return new TachographDataFileBuilderImpl();
    }

    @Generated
    public Driver getDriver() {
        return this.driver;
    }

    @Generated
    public Device getDevice() {
        return this.device;
    }

    @Generated
    public Byte[] getBinaryData() {
        return this.binaryData;
    }

    @Generated
    public Integer getOrigin() {
        return this.origin;
    }

    @Generated
    public String getOriginDescription() {
        return this.originDescription;
    }

    @Generated
    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    @Generated
    public LocalDateTime getUploadDateTime() {
        return this.uploadDateTime;
    }

    @Generated
    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public LocalDateTime getTimestampStart() {
        return this.timestampStart;
    }

    @Generated
    public LocalDateTime getTimestampEnd() {
        return this.timestampEnd;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public String getSummary() {
        return this.summary;
    }

    @Generated
    public Integer getSignature() {
        return this.signature;
    }

    @Generated
    public String getFileNameTgd() {
        return this.fileNameTgd;
    }

    @Generated
    public String getFileNameDdd() {
        return this.fileNameDdd;
    }

    @Generated
    public String getFileNameV1B() {
        return this.fileNameV1B;
    }

    @Generated
    public String getWarnings() {
        return this.warnings;
    }

    @Generated
    public String getErrors() {
        return this.errors;
    }

    @Generated
    public Integer getProcessingStatus() {
        return this.processingStatus;
    }

    @Generated
    public String getLockGaps() {
        return this.lockGaps;
    }

    @Generated
    public Boolean getArchived() {
        return this.archived;
    }

    @Generated
    public TachographDataFile setDriver(Driver driver) {
        this.driver = driver;
        return this;
    }

    @Generated
    public TachographDataFile setDevice(Device device) {
        this.device = device;
        return this;
    }

    @JsonDeserialize(using=ByteArrayDeserializer.class)
    @Generated
    public TachographDataFile setBinaryData(Byte[] binaryData) {
        this.binaryData = binaryData;
        return this;
    }

    @Generated
    public TachographDataFile setOrigin(Integer origin) {
        this.origin = origin;
        return this;
    }

    @Generated
    public TachographDataFile setOriginDescription(String originDescription) {
        this.originDescription = originDescription;
        return this;
    }

    @Generated
    public TachographDataFile setDateTime(LocalDateTime dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    @Generated
    public TachographDataFile setUploadDateTime(LocalDateTime uploadDateTime) {
        this.uploadDateTime = uploadDateTime;
        return this;
    }

    @Generated
    public TachographDataFile setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Generated
    public TachographDataFile setTimestampStart(LocalDateTime timestampStart) {
        this.timestampStart = timestampStart;
        return this;
    }

    @Generated
    public TachographDataFile setTimestampEnd(LocalDateTime timestampEnd) {
        this.timestampEnd = timestampEnd;
        return this;
    }

    @Generated
    public TachographDataFile setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Generated
    public TachographDataFile setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    @Generated
    public TachographDataFile setSignature(Integer signature) {
        this.signature = signature;
        return this;
    }

    @Generated
    public TachographDataFile setFileNameTgd(String fileNameTgd) {
        this.fileNameTgd = fileNameTgd;
        return this;
    }

    @Generated
    public TachographDataFile setFileNameDdd(String fileNameDdd) {
        this.fileNameDdd = fileNameDdd;
        return this;
    }

    @Generated
    public TachographDataFile setFileNameV1B(String fileNameV1B) {
        this.fileNameV1B = fileNameV1B;
        return this;
    }

    @Generated
    public TachographDataFile setWarnings(String warnings) {
        this.warnings = warnings;
        return this;
    }

    @Generated
    public TachographDataFile setErrors(String errors) {
        this.errors = errors;
        return this;
    }

    @Generated
    public TachographDataFile setProcessingStatus(Integer processingStatus) {
        this.processingStatus = processingStatus;
        return this;
    }

    @Generated
    public TachographDataFile setLockGaps(String lockGaps) {
        this.lockGaps = lockGaps;
        return this;
    }

    @Generated
    public TachographDataFile setArchived(Boolean archived) {
        this.archived = archived;
        return this;
    }

    @Generated
    public TachographDataFile() {
    }

    @Generated
    public static abstract class TachographDataFileBuilder<C extends TachographDataFile, B extends TachographDataFileBuilder<C, B>>
    extends EntityWithVersion.EntityWithVersionBuilder<C, B> {
        @Generated
        private Driver driver;
        @Generated
        private Device device;
        @Generated
        private Byte[] binaryData;
        @Generated
        private Integer origin;
        @Generated
        private String originDescription;
        @Generated
        private LocalDateTime dateTime;
        @Generated
        private LocalDateTime uploadDateTime;
        @Generated
        private LocalDateTime timestamp;
        @Generated
        private LocalDateTime timestampStart;
        @Generated
        private LocalDateTime timestampEnd;
        @Generated
        private String fileName;
        @Generated
        private String summary;
        @Generated
        private Integer signature;
        @Generated
        private String fileNameTgd;
        @Generated
        private String fileNameDdd;
        @Generated
        private String fileNameV1B;
        @Generated
        private String warnings;
        @Generated
        private String errors;
        @Generated
        private Integer processingStatus;
        @Generated
        private String lockGaps;
        @Generated
        private Boolean archived;

        @Generated
        public B driver(Driver driver) {
            this.driver = driver;
            return (B)this.self();
        }

        @Generated
        public B device(Device device) {
            this.device = device;
            return (B)this.self();
        }

        @JsonDeserialize(using=ByteArrayDeserializer.class)
        @Generated
        public B binaryData(Byte[] binaryData) {
            this.binaryData = binaryData;
            return (B)this.self();
        }

        @Generated
        public B origin(Integer origin) {
            this.origin = origin;
            return (B)this.self();
        }

        @Generated
        public B originDescription(String originDescription) {
            this.originDescription = originDescription;
            return (B)this.self();
        }

        @Generated
        public B dateTime(LocalDateTime dateTime) {
            this.dateTime = dateTime;
            return (B)this.self();
        }

        @Generated
        public B uploadDateTime(LocalDateTime uploadDateTime) {
            this.uploadDateTime = uploadDateTime;
            return (B)this.self();
        }

        @Generated
        public B timestamp(LocalDateTime timestamp) {
            this.timestamp = timestamp;
            return (B)this.self();
        }

        @Generated
        public B timestampStart(LocalDateTime timestampStart) {
            this.timestampStart = timestampStart;
            return (B)this.self();
        }

        @Generated
        public B timestampEnd(LocalDateTime timestampEnd) {
            this.timestampEnd = timestampEnd;
            return (B)this.self();
        }

        @Generated
        public B fileName(String fileName) {
            this.fileName = fileName;
            return (B)this.self();
        }

        @Generated
        public B summary(String summary) {
            this.summary = summary;
            return (B)this.self();
        }

        @Generated
        public B signature(Integer signature) {
            this.signature = signature;
            return (B)this.self();
        }

        @Generated
        public B fileNameTgd(String fileNameTgd) {
            this.fileNameTgd = fileNameTgd;
            return (B)this.self();
        }

        @Generated
        public B fileNameDdd(String fileNameDdd) {
            this.fileNameDdd = fileNameDdd;
            return (B)this.self();
        }

        @Generated
        public B fileNameV1B(String fileNameV1B) {
            this.fileNameV1B = fileNameV1B;
            return (B)this.self();
        }

        @Generated
        public B warnings(String warnings) {
            this.warnings = warnings;
            return (B)this.self();
        }

        @Generated
        public B errors(String errors) {
            this.errors = errors;
            return (B)this.self();
        }

        @Generated
        public B processingStatus(Integer processingStatus) {
            this.processingStatus = processingStatus;
            return (B)this.self();
        }

        @Generated
        public B lockGaps(String lockGaps) {
            this.lockGaps = lockGaps;
            return (B)this.self();
        }

        @Generated
        public B archived(Boolean archived) {
            this.archived = archived;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "TachographDataFile.TachographDataFileBuilder(super=" + super.toString() + ", driver=" + String.valueOf((Object)this.driver) + ", device=" + String.valueOf((Object)this.device) + ", binaryData=" + Arrays.deepToString(this.binaryData) + ", origin=" + this.origin + ", originDescription=" + this.originDescription + ", dateTime=" + String.valueOf(this.dateTime) + ", uploadDateTime=" + String.valueOf(this.uploadDateTime) + ", timestamp=" + String.valueOf(this.timestamp) + ", timestampStart=" + String.valueOf(this.timestampStart) + ", timestampEnd=" + String.valueOf(this.timestampEnd) + ", fileName=" + this.fileName + ", summary=" + this.summary + ", signature=" + this.signature + ", fileNameTgd=" + this.fileNameTgd + ", fileNameDdd=" + this.fileNameDdd + ", fileNameV1B=" + this.fileNameV1B + ", warnings=" + this.warnings + ", errors=" + this.errors + ", processingStatus=" + this.processingStatus + ", lockGaps=" + this.lockGaps + ", archived=" + this.archived + ")";
        }
    }

    @Generated
    private static final class TachographDataFileBuilderImpl
    extends TachographDataFileBuilder<TachographDataFile, TachographDataFileBuilderImpl> {
        @Generated
        private TachographDataFileBuilderImpl() {
        }

        @Override
        @Generated
        protected TachographDataFileBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TachographDataFile build() {
            return new TachographDataFile(this);
        }
    }
}

