/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.user;

import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Currency implements HasName
{
    NONE("None"),
    CAD("Cad"),
    HKD("Hkd"),
    USD("Usd"),
    AUD("Aud"),
    BRL("Brl"),
    CNY("Cny"),
    EUR("Eur"),
    INR("Inr"),
    IDR("Idr"),
    JPY("Jpy"),
    MXN("Mxn"),
    NZD("Nzd"),
    NOK("Nok"),
    PEN("Pen"),
    RUB("Rub"),
    SAR("Sar"),
    SGD("Sgd"),
    ZAR("Zar"),
    KRW("Krw"),
    SEK("Sek"),
    CHF("Chf"),
    TWD("Twd"),
    TRY("Try"),
    GBP("Gbp");

    @Generated
    private static final Logger log;
    private final String name;

    private Currency(String name) {
        this.name = name;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public static Currency findOrDefault(String name) {
        if (Util.isEmpty((String)name)) {
            log.warn("Empty value is not recognized for {} enum; returning default {}", (Object)Currency.class.getSimpleName(), (Object)NONE);
            return NONE;
        }
        Currency currency = Currency.findByName(name);
        if (currency != null) {
            return currency;
        }
        log.warn("{} is not recognized for {} enum; returning default {}", new Object[]{name, Currency.class.getSimpleName(), NONE});
        return NONE;
    }

    public static Currency findByName(String name) {
        if (Util.isEmpty((String)name)) {
            return null;
        }
        for (Currency currency : Currency.values()) {
            if (!currency.getName().equalsIgnoreCase(name.trim())) continue;
            return currency;
        }
        return null;
    }

    static {
        log = LoggerFactory.getLogger(Currency.class);
    }
}

