/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.Id;
import com.geotab.model.entity.NameEntityWithVersion;
import com.geotab.model.entity.certificate.Certificate;
import com.geotab.model.entity.fuel.FuelEconomyUnit;
import com.geotab.model.entity.group.Group;
import com.geotab.model.entity.groupfilter.GroupFilter;
import com.geotab.model.entity.user.Currency;
import com.geotab.model.entity.user.ElectricEnergyEconomyUnit;
import com.geotab.model.entity.user.HosRuleSet;
import com.geotab.model.entity.user.NoDriver;
import com.geotab.model.entity.user.NoUser;
import com.geotab.model.entity.user.SystemUser;
import com.geotab.model.entity.user.UnknownDriver;
import com.geotab.model.entity.user.UserAuthenticationType;
import com.geotab.model.entity.user.ZoneDisplayMode;
import com.geotab.model.entity.worktime.DayOfWeek;
import com.geotab.model.serialization.serdes.EntityCollectionAsIdCollectionSerializer;
import com.geotab.model.serialization.serdes.UserDeserializer;
import com.geotab.model.settings.GoogleMapStyle;
import com.geotab.model.settings.HereMapStyle;
import com.geotab.model.settings.MapView;
import com.geotab.model.settings.OpenStreetMapStyle;
import com.geotab.util.Util;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

@JsonDeserialize(using=UserDeserializer.class)
public class User
extends NameEntityWithVersion {
    protected Integer acceptedEULA;
    protected Integer driveGuideVersion;
    protected Integer wifiEULA;
    protected List<String> activeDashboardReports;
    protected List<String> bookmarks;
    protected LocalDateTime activeFrom;
    protected LocalDateTime activeTo;
    protected List<String> availableDashboardReports;
    protected String[][] cannedResponseOptions;
    @JsonProperty(value="changePassword")
    protected Boolean changePassword;
    protected String comment;
    @JsonSerialize(converter=EntityCollectionAsIdCollectionSerializer.class)
    protected List<Group> companyGroups;
    @JsonProperty(value="accessGroupFilter")
    protected GroupFilter accessGroupFilter;
    @JsonProperty(value="nullifyAccessGroupFilter")
    protected Boolean nullifyAccessGroupFilter;
    protected String dateFormat;
    protected String phoneNumber;
    protected Currency displayCurrency;
    protected String countryCode;
    protected String phoneNumberExtension;
    protected GoogleMapStyle defaultGoogleMapStyle;
    protected String defaultMapEngine;
    protected OpenStreetMapStyle defaultOpenStreetMapStyle;
    protected HereMapStyle defaultHereMapStyle;
    protected String defaultPage;
    protected String designation;
    protected String employeeNo;
    protected String firstName;
    protected FuelEconomyUnit fuelEconomyUnit;
    protected ElectricEnergyEconomyUnit electricEnergyEconomyUnit;
    protected HosRuleSet hosRuleSet;
    @JsonProperty(value="isYardMoveEnabled")
    protected Boolean isYardMoveEnabled;
    @JsonProperty(value="isPersonalConveyanceEnabled")
    protected Boolean isPersonalConveyanceEnabled;
    @JsonProperty(value="isExemptHOSEnabled")
    protected Boolean isExemptHOSEnabled;
    protected Double maxPCDistancePerDay;
    protected String authorityName;
    protected String authorityAddress;
    @JsonProperty(value="isEULAAccepted")
    protected Boolean isEULAAccepted;
    @JsonProperty(value="isNewsEnabled")
    protected Boolean isNewsEnabled = true;
    @JsonProperty(value="isServiceUpdatesEnabled")
    protected Boolean isServiceUpdatesEnabled;
    @JsonProperty(value="isLabsEnabled")
    protected Boolean isLabsEnabled;
    @JsonProperty(value="isMetric")
    protected Boolean isMetric = true;
    protected String language;
    protected DayOfWeek firstDayOfWeek;
    protected String lastName;
    protected List<MapView> mapViews;
    protected String password;
    @JsonSerialize(converter=EntityCollectionAsIdCollectionSerializer.class)
    protected List<Group> privateUserGroups;
    @JsonSerialize(converter=EntityCollectionAsIdCollectionSerializer.class)
    protected List<Group> reportGroups;
    @JsonSerialize(converter=EntityCollectionAsIdCollectionSerializer.class)
    protected List<Group> securityGroups;
    @JsonProperty(value="showClickOnceWarning")
    protected Boolean showClickOnceWarning;
    protected String timeZoneId;
    protected UserAuthenticationType userAuthenticationType;
    protected ZoneDisplayMode zoneDisplayMode;
    protected Certificate issuerCertificate;
    protected String companyName;
    protected String companyAddress;
    protected String carrierNumber;
    protected LocalDateTime lastAccessDate;
    @JsonProperty(value="isDriver")
    protected Boolean isDriver;
    @JsonProperty(value="isEmailReportEnabled")
    protected Boolean isEmailReportEnabled = true;

    public User(String id) {
        this.setId(new Id(id));
        this.setName(id);
    }

    public static User fromSystem(String id) {
        if (Util.isEmpty((String)id)) {
            return null;
        }
        if ("NoDriverId".equals(id)) {
            return NoDriver.getInstance();
        }
        if ("UnknownDriverId".equals(id)) {
            return UnknownDriver.getInstance();
        }
        if ("NoUserId".equals(id)) {
            return NoUser.getInstance();
        }
        if ("SystemUserId".equals(id)) {
            return SystemUser.getInstance();
        }
        return null;
    }

    @Generated
    protected User(UserBuilder<?, ?> b) {
        super(b);
        this.acceptedEULA = b.acceptedEULA;
        this.driveGuideVersion = b.driveGuideVersion;
        this.wifiEULA = b.wifiEULA;
        this.activeDashboardReports = b.activeDashboardReports;
        this.bookmarks = b.bookmarks;
        this.activeFrom = b.activeFrom;
        this.activeTo = b.activeTo;
        this.availableDashboardReports = b.availableDashboardReports;
        this.cannedResponseOptions = b.cannedResponseOptions;
        this.changePassword = b.changePassword;
        this.comment = b.comment;
        this.companyGroups = b.companyGroups;
        this.accessGroupFilter = b.accessGroupFilter;
        this.nullifyAccessGroupFilter = b.nullifyAccessGroupFilter;
        this.dateFormat = b.dateFormat;
        this.phoneNumber = b.phoneNumber;
        this.displayCurrency = b.displayCurrency;
        this.countryCode = b.countryCode;
        this.phoneNumberExtension = b.phoneNumberExtension;
        this.defaultGoogleMapStyle = b.defaultGoogleMapStyle;
        this.defaultMapEngine = b.defaultMapEngine;
        this.defaultOpenStreetMapStyle = b.defaultOpenStreetMapStyle;
        this.defaultHereMapStyle = b.defaultHereMapStyle;
        this.defaultPage = b.defaultPage;
        this.designation = b.designation;
        this.employeeNo = b.employeeNo;
        this.firstName = b.firstName;
        this.fuelEconomyUnit = b.fuelEconomyUnit;
        this.electricEnergyEconomyUnit = b.electricEnergyEconomyUnit;
        this.hosRuleSet = b.hosRuleSet;
        this.isYardMoveEnabled = b.isYardMoveEnabled;
        this.isPersonalConveyanceEnabled = b.isPersonalConveyanceEnabled;
        this.isExemptHOSEnabled = b.isExemptHOSEnabled;
        this.maxPCDistancePerDay = b.maxPCDistancePerDay;
        this.authorityName = b.authorityName;
        this.authorityAddress = b.authorityAddress;
        this.isEULAAccepted = b.isEULAAccepted;
        this.isNewsEnabled = b.isNewsEnabled;
        this.isServiceUpdatesEnabled = b.isServiceUpdatesEnabled;
        this.isLabsEnabled = b.isLabsEnabled;
        this.isMetric = b.isMetric;
        this.language = b.language;
        this.firstDayOfWeek = b.firstDayOfWeek;
        this.lastName = b.lastName;
        this.mapViews = b.mapViews;
        this.password = b.password;
        this.privateUserGroups = b.privateUserGroups;
        this.reportGroups = b.reportGroups;
        this.securityGroups = b.securityGroups;
        this.showClickOnceWarning = b.showClickOnceWarning;
        this.timeZoneId = b.timeZoneId;
        this.userAuthenticationType = b.userAuthenticationType;
        this.zoneDisplayMode = b.zoneDisplayMode;
        this.issuerCertificate = b.issuerCertificate;
        this.companyName = b.companyName;
        this.companyAddress = b.companyAddress;
        this.carrierNumber = b.carrierNumber;
        this.lastAccessDate = b.lastAccessDate;
        this.isDriver = b.isDriver;
        this.isEmailReportEnabled = b.isEmailReportEnabled;
    }

    @Generated
    public static UserBuilder<?, ?> userBuilder() {
        return new UserBuilderImpl();
    }

    @Generated
    public Integer getAcceptedEULA() {
        return this.acceptedEULA;
    }

    @Generated
    public Integer getDriveGuideVersion() {
        return this.driveGuideVersion;
    }

    @Generated
    public Integer getWifiEULA() {
        return this.wifiEULA;
    }

    @Generated
    public List<String> getActiveDashboardReports() {
        return this.activeDashboardReports;
    }

    @Generated
    public List<String> getBookmarks() {
        return this.bookmarks;
    }

    @Generated
    public LocalDateTime getActiveFrom() {
        return this.activeFrom;
    }

    @Generated
    public LocalDateTime getActiveTo() {
        return this.activeTo;
    }

    @Generated
    public List<String> getAvailableDashboardReports() {
        return this.availableDashboardReports;
    }

    @Generated
    public String[][] getCannedResponseOptions() {
        return this.cannedResponseOptions;
    }

    @Generated
    public Boolean getChangePassword() {
        return this.changePassword;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public List<Group> getCompanyGroups() {
        return this.companyGroups;
    }

    @Generated
    public GroupFilter getAccessGroupFilter() {
        return this.accessGroupFilter;
    }

    @Generated
    public Boolean getNullifyAccessGroupFilter() {
        return this.nullifyAccessGroupFilter;
    }

    @Generated
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Generated
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @Generated
    public Currency getDisplayCurrency() {
        return this.displayCurrency;
    }

    @Generated
    public String getCountryCode() {
        return this.countryCode;
    }

    @Generated
    public String getPhoneNumberExtension() {
        return this.phoneNumberExtension;
    }

    @Generated
    public GoogleMapStyle getDefaultGoogleMapStyle() {
        return this.defaultGoogleMapStyle;
    }

    @Generated
    public String getDefaultMapEngine() {
        return this.defaultMapEngine;
    }

    @Generated
    public OpenStreetMapStyle getDefaultOpenStreetMapStyle() {
        return this.defaultOpenStreetMapStyle;
    }

    @Generated
    public HereMapStyle getDefaultHereMapStyle() {
        return this.defaultHereMapStyle;
    }

    @Generated
    public String getDefaultPage() {
        return this.defaultPage;
    }

    @Generated
    public String getDesignation() {
        return this.designation;
    }

    @Generated
    public String getEmployeeNo() {
        return this.employeeNo;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public FuelEconomyUnit getFuelEconomyUnit() {
        return this.fuelEconomyUnit;
    }

    @Generated
    public ElectricEnergyEconomyUnit getElectricEnergyEconomyUnit() {
        return this.electricEnergyEconomyUnit;
    }

    @Generated
    public HosRuleSet getHosRuleSet() {
        return this.hosRuleSet;
    }

    @Generated
    public Boolean getIsYardMoveEnabled() {
        return this.isYardMoveEnabled;
    }

    @Generated
    public Boolean getIsPersonalConveyanceEnabled() {
        return this.isPersonalConveyanceEnabled;
    }

    @Generated
    public Boolean getIsExemptHOSEnabled() {
        return this.isExemptHOSEnabled;
    }

    @Generated
    public Double getMaxPCDistancePerDay() {
        return this.maxPCDistancePerDay;
    }

    @Generated
    public String getAuthorityName() {
        return this.authorityName;
    }

    @Generated
    public String getAuthorityAddress() {
        return this.authorityAddress;
    }

    @Generated
    public Boolean getIsEULAAccepted() {
        return this.isEULAAccepted;
    }

    @Generated
    public Boolean getIsNewsEnabled() {
        return this.isNewsEnabled;
    }

    @Generated
    public Boolean getIsServiceUpdatesEnabled() {
        return this.isServiceUpdatesEnabled;
    }

    @Generated
    public Boolean getIsLabsEnabled() {
        return this.isLabsEnabled;
    }

    @Generated
    public Boolean getIsMetric() {
        return this.isMetric;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public DayOfWeek getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public List<MapView> getMapViews() {
        return this.mapViews;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public List<Group> getPrivateUserGroups() {
        return this.privateUserGroups;
    }

    @Generated
    public List<Group> getReportGroups() {
        return this.reportGroups;
    }

    @Generated
    public List<Group> getSecurityGroups() {
        return this.securityGroups;
    }

    @Generated
    public Boolean getShowClickOnceWarning() {
        return this.showClickOnceWarning;
    }

    @Generated
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    @Generated
    public UserAuthenticationType getUserAuthenticationType() {
        return this.userAuthenticationType;
    }

    @Generated
    public ZoneDisplayMode getZoneDisplayMode() {
        return this.zoneDisplayMode;
    }

    @Generated
    public Certificate getIssuerCertificate() {
        return this.issuerCertificate;
    }

    @Generated
    public String getCompanyName() {
        return this.companyName;
    }

    @Generated
    public String getCompanyAddress() {
        return this.companyAddress;
    }

    @Generated
    public String getCarrierNumber() {
        return this.carrierNumber;
    }

    @Generated
    public LocalDateTime getLastAccessDate() {
        return this.lastAccessDate;
    }

    @Generated
    public Boolean getIsDriver() {
        return this.isDriver;
    }

    @Generated
    public Boolean getIsEmailReportEnabled() {
        return this.isEmailReportEnabled;
    }

    @Generated
    public User setAcceptedEULA(Integer acceptedEULA) {
        this.acceptedEULA = acceptedEULA;
        return this;
    }

    @Generated
    public User setDriveGuideVersion(Integer driveGuideVersion) {
        this.driveGuideVersion = driveGuideVersion;
        return this;
    }

    @Generated
    public User setWifiEULA(Integer wifiEULA) {
        this.wifiEULA = wifiEULA;
        return this;
    }

    @Generated
    public User setActiveDashboardReports(List<String> activeDashboardReports) {
        this.activeDashboardReports = activeDashboardReports;
        return this;
    }

    @Generated
    public User setBookmarks(List<String> bookmarks) {
        this.bookmarks = bookmarks;
        return this;
    }

    @Generated
    public User setActiveFrom(LocalDateTime activeFrom) {
        this.activeFrom = activeFrom;
        return this;
    }

    @Generated
    public User setActiveTo(LocalDateTime activeTo) {
        this.activeTo = activeTo;
        return this;
    }

    @Generated
    public User setAvailableDashboardReports(List<String> availableDashboardReports) {
        this.availableDashboardReports = availableDashboardReports;
        return this;
    }

    @Generated
    public User setCannedResponseOptions(String[][] cannedResponseOptions) {
        this.cannedResponseOptions = cannedResponseOptions;
        return this;
    }

    @JsonProperty(value="changePassword")
    @Generated
    public User setChangePassword(Boolean changePassword) {
        this.changePassword = changePassword;
        return this;
    }

    @Generated
    public User setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @Generated
    public User setCompanyGroups(List<Group> companyGroups) {
        this.companyGroups = companyGroups;
        return this;
    }

    @JsonProperty(value="accessGroupFilter")
    @Generated
    public User setAccessGroupFilter(GroupFilter accessGroupFilter) {
        this.accessGroupFilter = accessGroupFilter;
        return this;
    }

    @JsonProperty(value="nullifyAccessGroupFilter")
    @Generated
    public User setNullifyAccessGroupFilter(Boolean nullifyAccessGroupFilter) {
        this.nullifyAccessGroupFilter = nullifyAccessGroupFilter;
        return this;
    }

    @Generated
    public User setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    @Generated
    public User setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Generated
    public User setDisplayCurrency(Currency displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Generated
    public User setCountryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Generated
    public User setPhoneNumberExtension(String phoneNumberExtension) {
        this.phoneNumberExtension = phoneNumberExtension;
        return this;
    }

    @Generated
    public User setDefaultGoogleMapStyle(GoogleMapStyle defaultGoogleMapStyle) {
        this.defaultGoogleMapStyle = defaultGoogleMapStyle;
        return this;
    }

    @Generated
    public User setDefaultMapEngine(String defaultMapEngine) {
        this.defaultMapEngine = defaultMapEngine;
        return this;
    }

    @Generated
    public User setDefaultOpenStreetMapStyle(OpenStreetMapStyle defaultOpenStreetMapStyle) {
        this.defaultOpenStreetMapStyle = defaultOpenStreetMapStyle;
        return this;
    }

    @Generated
    public User setDefaultHereMapStyle(HereMapStyle defaultHereMapStyle) {
        this.defaultHereMapStyle = defaultHereMapStyle;
        return this;
    }

    @Generated
    public User setDefaultPage(String defaultPage) {
        this.defaultPage = defaultPage;
        return this;
    }

    @Generated
    public User setDesignation(String designation) {
        this.designation = designation;
        return this;
    }

    @Generated
    public User setEmployeeNo(String employeeNo) {
        this.employeeNo = employeeNo;
        return this;
    }

    @Generated
    public User setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Generated
    public User setFuelEconomyUnit(FuelEconomyUnit fuelEconomyUnit) {
        this.fuelEconomyUnit = fuelEconomyUnit;
        return this;
    }

    @Generated
    public User setElectricEnergyEconomyUnit(ElectricEnergyEconomyUnit electricEnergyEconomyUnit) {
        this.electricEnergyEconomyUnit = electricEnergyEconomyUnit;
        return this;
    }

    @Generated
    public User setHosRuleSet(HosRuleSet hosRuleSet) {
        this.hosRuleSet = hosRuleSet;
        return this;
    }

    @JsonProperty(value="isYardMoveEnabled")
    @Generated
    public User setIsYardMoveEnabled(Boolean isYardMoveEnabled) {
        this.isYardMoveEnabled = isYardMoveEnabled;
        return this;
    }

    @JsonProperty(value="isPersonalConveyanceEnabled")
    @Generated
    public User setIsPersonalConveyanceEnabled(Boolean isPersonalConveyanceEnabled) {
        this.isPersonalConveyanceEnabled = isPersonalConveyanceEnabled;
        return this;
    }

    @JsonProperty(value="isExemptHOSEnabled")
    @Generated
    public User setIsExemptHOSEnabled(Boolean isExemptHOSEnabled) {
        this.isExemptHOSEnabled = isExemptHOSEnabled;
        return this;
    }

    @Generated
    public User setMaxPCDistancePerDay(Double maxPCDistancePerDay) {
        this.maxPCDistancePerDay = maxPCDistancePerDay;
        return this;
    }

    @Generated
    public User setAuthorityName(String authorityName) {
        this.authorityName = authorityName;
        return this;
    }

    @Generated
    public User setAuthorityAddress(String authorityAddress) {
        this.authorityAddress = authorityAddress;
        return this;
    }

    @JsonProperty(value="isEULAAccepted")
    @Generated
    public User setIsEULAAccepted(Boolean isEULAAccepted) {
        this.isEULAAccepted = isEULAAccepted;
        return this;
    }

    @JsonProperty(value="isNewsEnabled")
    @Generated
    public User setIsNewsEnabled(Boolean isNewsEnabled) {
        this.isNewsEnabled = isNewsEnabled;
        return this;
    }

    @JsonProperty(value="isServiceUpdatesEnabled")
    @Generated
    public User setIsServiceUpdatesEnabled(Boolean isServiceUpdatesEnabled) {
        this.isServiceUpdatesEnabled = isServiceUpdatesEnabled;
        return this;
    }

    @JsonProperty(value="isLabsEnabled")
    @Generated
    public User setIsLabsEnabled(Boolean isLabsEnabled) {
        this.isLabsEnabled = isLabsEnabled;
        return this;
    }

    @JsonProperty(value="isMetric")
    @Generated
    public User setIsMetric(Boolean isMetric) {
        this.isMetric = isMetric;
        return this;
    }

    @Generated
    public User setLanguage(String language) {
        this.language = language;
        return this;
    }

    @Generated
    public User setFirstDayOfWeek(DayOfWeek firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
        return this;
    }

    @Generated
    public User setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Generated
    public User setMapViews(List<MapView> mapViews) {
        this.mapViews = mapViews;
        return this;
    }

    @Generated
    public User setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public User setPrivateUserGroups(List<Group> privateUserGroups) {
        this.privateUserGroups = privateUserGroups;
        return this;
    }

    @Generated
    public User setReportGroups(List<Group> reportGroups) {
        this.reportGroups = reportGroups;
        return this;
    }

    @Generated
    public User setSecurityGroups(List<Group> securityGroups) {
        this.securityGroups = securityGroups;
        return this;
    }

    @JsonProperty(value="showClickOnceWarning")
    @Generated
    public User setShowClickOnceWarning(Boolean showClickOnceWarning) {
        this.showClickOnceWarning = showClickOnceWarning;
        return this;
    }

    @Generated
    public User setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
        return this;
    }

    @Generated
    public User setUserAuthenticationType(UserAuthenticationType userAuthenticationType) {
        this.userAuthenticationType = userAuthenticationType;
        return this;
    }

    @Generated
    public User setZoneDisplayMode(ZoneDisplayMode zoneDisplayMode) {
        this.zoneDisplayMode = zoneDisplayMode;
        return this;
    }

    @Generated
    public User setIssuerCertificate(Certificate issuerCertificate) {
        this.issuerCertificate = issuerCertificate;
        return this;
    }

    @Generated
    public User setCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @Generated
    public User setCompanyAddress(String companyAddress) {
        this.companyAddress = companyAddress;
        return this;
    }

    @Generated
    public User setCarrierNumber(String carrierNumber) {
        this.carrierNumber = carrierNumber;
        return this;
    }

    @Generated
    public User setLastAccessDate(LocalDateTime lastAccessDate) {
        this.lastAccessDate = lastAccessDate;
        return this;
    }

    @JsonProperty(value="isDriver")
    @Generated
    public User setIsDriver(Boolean isDriver) {
        this.isDriver = isDriver;
        return this;
    }

    @JsonProperty(value="isEmailReportEnabled")
    @Generated
    public User setIsEmailReportEnabled(Boolean isEmailReportEnabled) {
        this.isEmailReportEnabled = isEmailReportEnabled;
        return this;
    }

    @Generated
    public User() {
    }

    @Generated
    public static abstract class UserBuilder<C extends User, B extends UserBuilder<C, B>>
    extends NameEntityWithVersion.NameEntityWithVersionBuilder<C, B> {
        @Generated
        private Integer acceptedEULA;
        @Generated
        private Integer driveGuideVersion;
        @Generated
        private Integer wifiEULA;
        @Generated
        private List<String> activeDashboardReports;
        @Generated
        private List<String> bookmarks;
        @Generated
        private LocalDateTime activeFrom;
        @Generated
        private LocalDateTime activeTo;
        @Generated
        private List<String> availableDashboardReports;
        @Generated
        private String[][] cannedResponseOptions;
        @Generated
        private Boolean changePassword;
        @Generated
        private String comment;
        @Generated
        private List<Group> companyGroups;
        @Generated
        private GroupFilter accessGroupFilter;
        @Generated
        private Boolean nullifyAccessGroupFilter;
        @Generated
        private String dateFormat;
        @Generated
        private String phoneNumber;
        @Generated
        private Currency displayCurrency;
        @Generated
        private String countryCode;
        @Generated
        private String phoneNumberExtension;
        @Generated
        private GoogleMapStyle defaultGoogleMapStyle;
        @Generated
        private String defaultMapEngine;
        @Generated
        private OpenStreetMapStyle defaultOpenStreetMapStyle;
        @Generated
        private HereMapStyle defaultHereMapStyle;
        @Generated
        private String defaultPage;
        @Generated
        private String designation;
        @Generated
        private String employeeNo;
        @Generated
        private String firstName;
        @Generated
        private FuelEconomyUnit fuelEconomyUnit;
        @Generated
        private ElectricEnergyEconomyUnit electricEnergyEconomyUnit;
        @Generated
        private HosRuleSet hosRuleSet;
        @Generated
        private Boolean isYardMoveEnabled;
        @Generated
        private Boolean isPersonalConveyanceEnabled;
        @Generated
        private Boolean isExemptHOSEnabled;
        @Generated
        private Double maxPCDistancePerDay;
        @Generated
        private String authorityName;
        @Generated
        private String authorityAddress;
        @Generated
        private Boolean isEULAAccepted;
        @Generated
        private Boolean isNewsEnabled;
        @Generated
        private Boolean isServiceUpdatesEnabled;
        @Generated
        private Boolean isLabsEnabled;
        @Generated
        private Boolean isMetric;
        @Generated
        private String language;
        @Generated
        private DayOfWeek firstDayOfWeek;
        @Generated
        private String lastName;
        @Generated
        private List<MapView> mapViews;
        @Generated
        private String password;
        @Generated
        private List<Group> privateUserGroups;
        @Generated
        private List<Group> reportGroups;
        @Generated
        private List<Group> securityGroups;
        @Generated
        private Boolean showClickOnceWarning;
        @Generated
        private String timeZoneId;
        @Generated
        private UserAuthenticationType userAuthenticationType;
        @Generated
        private ZoneDisplayMode zoneDisplayMode;
        @Generated
        private Certificate issuerCertificate;
        @Generated
        private String companyName;
        @Generated
        private String companyAddress;
        @Generated
        private String carrierNumber;
        @Generated
        private LocalDateTime lastAccessDate;
        @Generated
        private Boolean isDriver;
        @Generated
        private Boolean isEmailReportEnabled;

        @Generated
        public B acceptedEULA(Integer acceptedEULA) {
            this.acceptedEULA = acceptedEULA;
            return (B)this.self();
        }

        @Generated
        public B driveGuideVersion(Integer driveGuideVersion) {
            this.driveGuideVersion = driveGuideVersion;
            return (B)this.self();
        }

        @Generated
        public B wifiEULA(Integer wifiEULA) {
            this.wifiEULA = wifiEULA;
            return (B)this.self();
        }

        @Generated
        public B activeDashboardReports(List<String> activeDashboardReports) {
            this.activeDashboardReports = activeDashboardReports;
            return (B)this.self();
        }

        @Generated
        public B bookmarks(List<String> bookmarks) {
            this.bookmarks = bookmarks;
            return (B)this.self();
        }

        @Generated
        public B activeFrom(LocalDateTime activeFrom) {
            this.activeFrom = activeFrom;
            return (B)this.self();
        }

        @Generated
        public B activeTo(LocalDateTime activeTo) {
            this.activeTo = activeTo;
            return (B)this.self();
        }

        @Generated
        public B availableDashboardReports(List<String> availableDashboardReports) {
            this.availableDashboardReports = availableDashboardReports;
            return (B)this.self();
        }

        @Generated
        public B cannedResponseOptions(String[][] cannedResponseOptions) {
            this.cannedResponseOptions = cannedResponseOptions;
            return (B)this.self();
        }

        @JsonProperty(value="changePassword")
        @Generated
        public B changePassword(Boolean changePassword) {
            this.changePassword = changePassword;
            return (B)this.self();
        }

        @Generated
        public B comment(String comment) {
            this.comment = comment;
            return (B)this.self();
        }

        @Generated
        public B companyGroups(List<Group> companyGroups) {
            this.companyGroups = companyGroups;
            return (B)this.self();
        }

        @JsonProperty(value="accessGroupFilter")
        @Generated
        public B accessGroupFilter(GroupFilter accessGroupFilter) {
            this.accessGroupFilter = accessGroupFilter;
            return (B)this.self();
        }

        @JsonProperty(value="nullifyAccessGroupFilter")
        @Generated
        public B nullifyAccessGroupFilter(Boolean nullifyAccessGroupFilter) {
            this.nullifyAccessGroupFilter = nullifyAccessGroupFilter;
            return (B)this.self();
        }

        @Generated
        public B dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return (B)this.self();
        }

        @Generated
        public B phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return (B)this.self();
        }

        @Generated
        public B displayCurrency(Currency displayCurrency) {
            this.displayCurrency = displayCurrency;
            return (B)this.self();
        }

        @Generated
        public B countryCode(String countryCode) {
            this.countryCode = countryCode;
            return (B)this.self();
        }

        @Generated
        public B phoneNumberExtension(String phoneNumberExtension) {
            this.phoneNumberExtension = phoneNumberExtension;
            return (B)this.self();
        }

        @Generated
        public B defaultGoogleMapStyle(GoogleMapStyle defaultGoogleMapStyle) {
            this.defaultGoogleMapStyle = defaultGoogleMapStyle;
            return (B)this.self();
        }

        @Generated
        public B defaultMapEngine(String defaultMapEngine) {
            this.defaultMapEngine = defaultMapEngine;
            return (B)this.self();
        }

        @Generated
        public B defaultOpenStreetMapStyle(OpenStreetMapStyle defaultOpenStreetMapStyle) {
            this.defaultOpenStreetMapStyle = defaultOpenStreetMapStyle;
            return (B)this.self();
        }

        @Generated
        public B defaultHereMapStyle(HereMapStyle defaultHereMapStyle) {
            this.defaultHereMapStyle = defaultHereMapStyle;
            return (B)this.self();
        }

        @Generated
        public B defaultPage(String defaultPage) {
            this.defaultPage = defaultPage;
            return (B)this.self();
        }

        @Generated
        public B designation(String designation) {
            this.designation = designation;
            return (B)this.self();
        }

        @Generated
        public B employeeNo(String employeeNo) {
            this.employeeNo = employeeNo;
            return (B)this.self();
        }

        @Generated
        public B firstName(String firstName) {
            this.firstName = firstName;
            return (B)this.self();
        }

        @Generated
        public B fuelEconomyUnit(FuelEconomyUnit fuelEconomyUnit) {
            this.fuelEconomyUnit = fuelEconomyUnit;
            return (B)this.self();
        }

        @Generated
        public B electricEnergyEconomyUnit(ElectricEnergyEconomyUnit electricEnergyEconomyUnit) {
            this.electricEnergyEconomyUnit = electricEnergyEconomyUnit;
            return (B)this.self();
        }

        @Generated
        public B hosRuleSet(HosRuleSet hosRuleSet) {
            this.hosRuleSet = hosRuleSet;
            return (B)this.self();
        }

        @JsonProperty(value="isYardMoveEnabled")
        @Generated
        public B isYardMoveEnabled(Boolean isYardMoveEnabled) {
            this.isYardMoveEnabled = isYardMoveEnabled;
            return (B)this.self();
        }

        @JsonProperty(value="isPersonalConveyanceEnabled")
        @Generated
        public B isPersonalConveyanceEnabled(Boolean isPersonalConveyanceEnabled) {
            this.isPersonalConveyanceEnabled = isPersonalConveyanceEnabled;
            return (B)this.self();
        }

        @JsonProperty(value="isExemptHOSEnabled")
        @Generated
        public B isExemptHOSEnabled(Boolean isExemptHOSEnabled) {
            this.isExemptHOSEnabled = isExemptHOSEnabled;
            return (B)this.self();
        }

        @Generated
        public B maxPCDistancePerDay(Double maxPCDistancePerDay) {
            this.maxPCDistancePerDay = maxPCDistancePerDay;
            return (B)this.self();
        }

        @Generated
        public B authorityName(String authorityName) {
            this.authorityName = authorityName;
            return (B)this.self();
        }

        @Generated
        public B authorityAddress(String authorityAddress) {
            this.authorityAddress = authorityAddress;
            return (B)this.self();
        }

        @JsonProperty(value="isEULAAccepted")
        @Generated
        public B isEULAAccepted(Boolean isEULAAccepted) {
            this.isEULAAccepted = isEULAAccepted;
            return (B)this.self();
        }

        @JsonProperty(value="isNewsEnabled")
        @Generated
        public B isNewsEnabled(Boolean isNewsEnabled) {
            this.isNewsEnabled = isNewsEnabled;
            return (B)this.self();
        }

        @JsonProperty(value="isServiceUpdatesEnabled")
        @Generated
        public B isServiceUpdatesEnabled(Boolean isServiceUpdatesEnabled) {
            this.isServiceUpdatesEnabled = isServiceUpdatesEnabled;
            return (B)this.self();
        }

        @JsonProperty(value="isLabsEnabled")
        @Generated
        public B isLabsEnabled(Boolean isLabsEnabled) {
            this.isLabsEnabled = isLabsEnabled;
            return (B)this.self();
        }

        @JsonProperty(value="isMetric")
        @Generated
        public B isMetric(Boolean isMetric) {
            this.isMetric = isMetric;
            return (B)this.self();
        }

        @Generated
        public B language(String language) {
            this.language = language;
            return (B)this.self();
        }

        @Generated
        public B firstDayOfWeek(DayOfWeek firstDayOfWeek) {
            this.firstDayOfWeek = firstDayOfWeek;
            return (B)this.self();
        }

        @Generated
        public B lastName(String lastName) {
            this.lastName = lastName;
            return (B)this.self();
        }

        @Generated
        public B mapViews(List<MapView> mapViews) {
            this.mapViews = mapViews;
            return (B)this.self();
        }

        @Generated
        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        @Generated
        public B privateUserGroups(List<Group> privateUserGroups) {
            this.privateUserGroups = privateUserGroups;
            return (B)this.self();
        }

        @Generated
        public B reportGroups(List<Group> reportGroups) {
            this.reportGroups = reportGroups;
            return (B)this.self();
        }

        @Generated
        public B securityGroups(List<Group> securityGroups) {
            this.securityGroups = securityGroups;
            return (B)this.self();
        }

        @JsonProperty(value="showClickOnceWarning")
        @Generated
        public B showClickOnceWarning(Boolean showClickOnceWarning) {
            this.showClickOnceWarning = showClickOnceWarning;
            return (B)this.self();
        }

        @Generated
        public B timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return (B)this.self();
        }

        @Generated
        public B userAuthenticationType(UserAuthenticationType userAuthenticationType) {
            this.userAuthenticationType = userAuthenticationType;
            return (B)this.self();
        }

        @Generated
        public B zoneDisplayMode(ZoneDisplayMode zoneDisplayMode) {
            this.zoneDisplayMode = zoneDisplayMode;
            return (B)this.self();
        }

        @Generated
        public B issuerCertificate(Certificate issuerCertificate) {
            this.issuerCertificate = issuerCertificate;
            return (B)this.self();
        }

        @Generated
        public B companyName(String companyName) {
            this.companyName = companyName;
            return (B)this.self();
        }

        @Generated
        public B companyAddress(String companyAddress) {
            this.companyAddress = companyAddress;
            return (B)this.self();
        }

        @Generated
        public B carrierNumber(String carrierNumber) {
            this.carrierNumber = carrierNumber;
            return (B)this.self();
        }

        @Generated
        public B lastAccessDate(LocalDateTime lastAccessDate) {
            this.lastAccessDate = lastAccessDate;
            return (B)this.self();
        }

        @JsonProperty(value="isDriver")
        @Generated
        public B isDriver(Boolean isDriver) {
            this.isDriver = isDriver;
            return (B)this.self();
        }

        @JsonProperty(value="isEmailReportEnabled")
        @Generated
        public B isEmailReportEnabled(Boolean isEmailReportEnabled) {
            this.isEmailReportEnabled = isEmailReportEnabled;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "User.UserBuilder(super=" + super.toString() + ", acceptedEULA=" + this.acceptedEULA + ", driveGuideVersion=" + this.driveGuideVersion + ", wifiEULA=" + this.wifiEULA + ", activeDashboardReports=" + String.valueOf(this.activeDashboardReports) + ", bookmarks=" + String.valueOf(this.bookmarks) + ", activeFrom=" + String.valueOf(this.activeFrom) + ", activeTo=" + String.valueOf(this.activeTo) + ", availableDashboardReports=" + String.valueOf(this.availableDashboardReports) + ", cannedResponseOptions=" + Arrays.deepToString((Object[])this.cannedResponseOptions) + ", changePassword=" + this.changePassword + ", comment=" + this.comment + ", companyGroups=" + String.valueOf(this.companyGroups) + ", accessGroupFilter=" + String.valueOf((Object)this.accessGroupFilter) + ", nullifyAccessGroupFilter=" + this.nullifyAccessGroupFilter + ", dateFormat=" + this.dateFormat + ", phoneNumber=" + this.phoneNumber + ", displayCurrency=" + String.valueOf((Object)this.displayCurrency) + ", countryCode=" + this.countryCode + ", phoneNumberExtension=" + this.phoneNumberExtension + ", defaultGoogleMapStyle=" + String.valueOf((Object)this.defaultGoogleMapStyle) + ", defaultMapEngine=" + this.defaultMapEngine + ", defaultOpenStreetMapStyle=" + String.valueOf((Object)this.defaultOpenStreetMapStyle) + ", defaultHereMapStyle=" + String.valueOf((Object)this.defaultHereMapStyle) + ", defaultPage=" + this.defaultPage + ", designation=" + this.designation + ", employeeNo=" + this.employeeNo + ", firstName=" + this.firstName + ", fuelEconomyUnit=" + String.valueOf((Object)this.fuelEconomyUnit) + ", electricEnergyEconomyUnit=" + String.valueOf((Object)this.electricEnergyEconomyUnit) + ", hosRuleSet=" + String.valueOf((Object)this.hosRuleSet) + ", isYardMoveEnabled=" + this.isYardMoveEnabled + ", isPersonalConveyanceEnabled=" + this.isPersonalConveyanceEnabled + ", isExemptHOSEnabled=" + this.isExemptHOSEnabled + ", maxPCDistancePerDay=" + this.maxPCDistancePerDay + ", authorityName=" + this.authorityName + ", authorityAddress=" + this.authorityAddress + ", isEULAAccepted=" + this.isEULAAccepted + ", isNewsEnabled=" + this.isNewsEnabled + ", isServiceUpdatesEnabled=" + this.isServiceUpdatesEnabled + ", isLabsEnabled=" + this.isLabsEnabled + ", isMetric=" + this.isMetric + ", language=" + this.language + ", firstDayOfWeek=" + String.valueOf((Object)this.firstDayOfWeek) + ", lastName=" + this.lastName + ", mapViews=" + String.valueOf(this.mapViews) + ", password=" + this.password + ", privateUserGroups=" + String.valueOf(this.privateUserGroups) + ", reportGroups=" + String.valueOf(this.reportGroups) + ", securityGroups=" + String.valueOf(this.securityGroups) + ", showClickOnceWarning=" + this.showClickOnceWarning + ", timeZoneId=" + this.timeZoneId + ", userAuthenticationType=" + String.valueOf((Object)this.userAuthenticationType) + ", zoneDisplayMode=" + String.valueOf((Object)this.zoneDisplayMode) + ", issuerCertificate=" + String.valueOf((Object)this.issuerCertificate) + ", companyName=" + this.companyName + ", companyAddress=" + this.companyAddress + ", carrierNumber=" + this.carrierNumber + ", lastAccessDate=" + String.valueOf(this.lastAccessDate) + ", isDriver=" + this.isDriver + ", isEmailReportEnabled=" + this.isEmailReportEnabled + ")";
        }
    }

    @Generated
    private static final class UserBuilderImpl
    extends UserBuilder<User, UserBuilderImpl> {
        @Generated
        private UserBuilderImpl() {
        }

        @Override
        @Generated
        protected UserBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public User build() {
            return new User(this);
        }
    }
}

