/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.zone;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.Id;
import com.geotab.model.coordinate.Coordinate;
import com.geotab.model.drawing.Color;
import com.geotab.model.entity.NameEntityWithVersion;
import com.geotab.model.entity.group.Group;
import com.geotab.model.entity.zone.NoZone;
import com.geotab.model.entity.zone.type.ZoneType;
import com.geotab.model.serialization.serdes.EntityCollectionAsIdCollectionSerializer;
import com.geotab.util.Util;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;

public class Zone
extends NameEntityWithVersion {
    private String comment;
    private Boolean displayed;
    private List<ZoneType> zoneTypes;
    private List<Coordinate> points;
    private LocalDateTime activeFrom;
    private LocalDateTime activeTo;
    private Color fillColor;
    private Boolean mustIdentifyStops;
    @JsonSerialize(converter=EntityCollectionAsIdCollectionSerializer.class)
    private List<Group> groups;
    private String externalReference;

    @JsonIgnore
    public Long getVersion() {
        return super.getVersion();
    }

    public Zone(String id) {
        this.setId(new Id(id));
        this.setName(id);
    }

    public static Zone fromSystem(String id) {
        if (Util.isEmpty((String)id)) {
            return null;
        }
        if ("NoZoneId".equals(id)) {
            return NoZone.getInstance();
        }
        return null;
    }

    @Generated
    protected Zone(ZoneBuilder<?, ?> b) {
        super(b);
        this.comment = b.comment;
        this.displayed = b.displayed;
        this.zoneTypes = b.zoneTypes;
        this.points = b.points;
        this.activeFrom = b.activeFrom;
        this.activeTo = b.activeTo;
        this.fillColor = b.fillColor;
        this.mustIdentifyStops = b.mustIdentifyStops;
        this.groups = b.groups;
        this.externalReference = b.externalReference;
    }

    @Generated
    public static ZoneBuilder<?, ?> builder() {
        return new ZoneBuilderImpl();
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public Boolean getDisplayed() {
        return this.displayed;
    }

    @Generated
    public List<ZoneType> getZoneTypes() {
        return this.zoneTypes;
    }

    @Generated
    public List<Coordinate> getPoints() {
        return this.points;
    }

    @Generated
    public LocalDateTime getActiveFrom() {
        return this.activeFrom;
    }

    @Generated
    public LocalDateTime getActiveTo() {
        return this.activeTo;
    }

    @Generated
    public Color getFillColor() {
        return this.fillColor;
    }

    @Generated
    public Boolean getMustIdentifyStops() {
        return this.mustIdentifyStops;
    }

    @Generated
    public List<Group> getGroups() {
        return this.groups;
    }

    @Generated
    public String getExternalReference() {
        return this.externalReference;
    }

    @Generated
    public Zone setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @Generated
    public Zone setDisplayed(Boolean displayed) {
        this.displayed = displayed;
        return this;
    }

    @Generated
    public Zone setZoneTypes(List<ZoneType> zoneTypes) {
        this.zoneTypes = zoneTypes;
        return this;
    }

    @Generated
    public Zone setPoints(List<Coordinate> points) {
        this.points = points;
        return this;
    }

    @Generated
    public Zone setActiveFrom(LocalDateTime activeFrom) {
        this.activeFrom = activeFrom;
        return this;
    }

    @Generated
    public Zone setActiveTo(LocalDateTime activeTo) {
        this.activeTo = activeTo;
        return this;
    }

    @Generated
    public Zone setFillColor(Color fillColor) {
        this.fillColor = fillColor;
        return this;
    }

    @Generated
    public Zone setMustIdentifyStops(Boolean mustIdentifyStops) {
        this.mustIdentifyStops = mustIdentifyStops;
        return this;
    }

    @Generated
    public Zone setGroups(List<Group> groups) {
        this.groups = groups;
        return this;
    }

    @Generated
    public Zone setExternalReference(String externalReference) {
        this.externalReference = externalReference;
        return this;
    }

    @Generated
    public Zone() {
    }

    @Generated
    public static abstract class ZoneBuilder<C extends Zone, B extends ZoneBuilder<C, B>>
    extends NameEntityWithVersion.NameEntityWithVersionBuilder<C, B> {
        @Generated
        private String comment;
        @Generated
        private Boolean displayed;
        @Generated
        private List<ZoneType> zoneTypes;
        @Generated
        private List<Coordinate> points;
        @Generated
        private LocalDateTime activeFrom;
        @Generated
        private LocalDateTime activeTo;
        @Generated
        private Color fillColor;
        @Generated
        private Boolean mustIdentifyStops;
        @Generated
        private List<Group> groups;
        @Generated
        private String externalReference;

        @Generated
        public B comment(String comment) {
            this.comment = comment;
            return (B)this.self();
        }

        @Generated
        public B displayed(Boolean displayed) {
            this.displayed = displayed;
            return (B)this.self();
        }

        @Generated
        public B zoneTypes(List<ZoneType> zoneTypes) {
            this.zoneTypes = zoneTypes;
            return (B)this.self();
        }

        @Generated
        public B points(List<Coordinate> points) {
            this.points = points;
            return (B)this.self();
        }

        @Generated
        public B activeFrom(LocalDateTime activeFrom) {
            this.activeFrom = activeFrom;
            return (B)this.self();
        }

        @Generated
        public B activeTo(LocalDateTime activeTo) {
            this.activeTo = activeTo;
            return (B)this.self();
        }

        @Generated
        public B fillColor(Color fillColor) {
            this.fillColor = fillColor;
            return (B)this.self();
        }

        @Generated
        public B mustIdentifyStops(Boolean mustIdentifyStops) {
            this.mustIdentifyStops = mustIdentifyStops;
            return (B)this.self();
        }

        @Generated
        public B groups(List<Group> groups) {
            this.groups = groups;
            return (B)this.self();
        }

        @Generated
        public B externalReference(String externalReference) {
            this.externalReference = externalReference;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Zone.ZoneBuilder(super=" + super.toString() + ", comment=" + this.comment + ", displayed=" + this.displayed + ", zoneTypes=" + String.valueOf(this.zoneTypes) + ", points=" + String.valueOf(this.points) + ", activeFrom=" + String.valueOf(this.activeFrom) + ", activeTo=" + String.valueOf(this.activeTo) + ", fillColor=" + String.valueOf(this.fillColor) + ", mustIdentifyStops=" + this.mustIdentifyStops + ", groups=" + String.valueOf(this.groups) + ", externalReference=" + this.externalReference + ")";
        }
    }

    @Generated
    private static final class ZoneBuilderImpl
    extends ZoneBuilder<Zone, ZoneBuilderImpl> {
        @Generated
        private ZoneBuilderImpl() {
        }

        @Override
        @Generated
        protected ZoneBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Zone build() {
            return new Zone(this);
        }
    }
}

