/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.geotab.model.Id;
import com.geotab.model.entity.Entity;
import com.geotab.model.entity.controller.Controller;
import com.geotab.model.entity.enginetype.EngineType;
import com.geotab.model.entity.exceptionevent.ExceptionEvent;
import com.geotab.model.entity.exceptionevent.state.ExceptionEventState;
import com.geotab.model.entity.failuremode.FailureMode;
import com.geotab.model.entity.faultdata.FaultStatus;
import com.geotab.model.entity.notification.NotificationBinaryFile;
import com.geotab.model.entity.parametergroup.ParameterGroup;
import com.geotab.model.entity.recipient.Recipient;
import com.geotab.model.entity.rule.Rule;
import com.geotab.model.entity.source.Source;
import com.geotab.model.entity.unitofmeasure.UnitOfMeasure;
import com.geotab.model.entity.worktime.WorkTime;
import com.geotab.model.entity.zone.Zone;
import com.geotab.model.entity.zone.type.ZoneType;
import com.geotab.model.serialization.ObjectMapperExtension;
import com.geotab.util.Util;
import java.io.IOException;
import java.util.Optional;

public class MyObjectMapperExtension
implements ObjectMapperExtension {
    public void configure(ObjectMapper om) {
        om.registerModule((Module)new SimpleModule("api-system-deserializers-module").setDeserializerModifier((BeanDeserializerModifier)new MyBeanDeserializerModifier()));
    }

    static class MyBeanDeserializerModifier
    extends BeanDeserializerModifier {
        MyBeanDeserializerModifier() {
        }

        public JsonDeserializer<?> modifyDeserializer(DeserializationConfig c, BeanDescription b, JsonDeserializer<?> d) {
            Class t = b.getBeanClass();
            if (Recipient.class.isAssignableFrom(t)) {
                return MyBeanDeserializerModifier.sys(d, (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)Recipient::fromSystem), (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)id -> ((Recipient.RecipientBuilder)Recipient.builder().id((String)id)).build()));
            }
            if (Controller.class.isAssignableFrom(t)) {
                return MyBeanDeserializerModifier.sys(d, (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)Controller::fromSystem), (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)id -> ((Controller.ControllerBuilder)Controller.builder().id((String)id)).build()));
            }
            if (Rule.class.isAssignableFrom(t)) {
                return MyBeanDeserializerModifier.sys(d, (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)Rule::fromSystem), (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)Rule::new));
            }
            if (Source.class.isAssignableFrom(t)) {
                return MyBeanDeserializerModifier.sys(d, (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)Source::fromSystem), (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)Source::new));
            }
            if (EngineType.class.isAssignableFrom(t)) {
                return MyBeanDeserializerModifier.sys(d, (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)EngineType::fromSystem), (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)id -> ((EngineType.EngineTypeBuilder)EngineType.builder().id((String)id)).build()));
            }
            if (ExceptionEvent.class.isAssignableFrom(t)) {
                return MyBeanDeserializerModifier.sys(d, (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)ExceptionEvent::fromSystem), (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)id -> ((ExceptionEvent.ExceptionEventBuilder)ExceptionEvent.builder().id((String)id)).build()));
            }
            if (ExceptionEventState.class.isAssignableFrom(t)) {
                return MyBeanDeserializerModifier.sys(d, (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)ExceptionEventState::fromSystem), (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)id -> ((ExceptionEventState.ExceptionEventStateBuilder)ExceptionEventState.builder().id((String)id)).build()));
            }
            if (FailureMode.class.isAssignableFrom(t)) {
                return MyBeanDeserializerModifier.sys(d, (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)FailureMode::fromSystem), (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)id -> ((FailureMode.FailureModeBuilder)FailureMode.builder().id((String)id)).build()));
            }
            if (FaultStatus.class.isAssignableFrom(t)) {
                return MyBeanDeserializerModifier.sys(d, (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)FaultStatus::fromSystem), (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)FaultStatus::new));
            }
            if (NotificationBinaryFile.class.isAssignableFrom(t)) {
                return MyBeanDeserializerModifier.sys(d, (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)NotificationBinaryFile::fromSystem), (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)NotificationBinaryFile::new));
            }
            if (ParameterGroup.class.isAssignableFrom(t)) {
                return MyBeanDeserializerModifier.sys(d, (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)ParameterGroup::fromSystem), (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)ParameterGroup::new));
            }
            if (ZoneType.class.isAssignableFrom(t)) {
                return MyBeanDeserializerModifier.sys(d, (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)ZoneType::fromSystem), (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)ZoneType::new));
            }
            if (Zone.class.isAssignableFrom(t)) {
                return MyBeanDeserializerModifier.sys(d, (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)Zone::fromSystem), (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)Zone::new));
            }
            if (WorkTime.class.isAssignableFrom(t)) {
                return MyBeanDeserializerModifier.sys(d, (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)WorkTime::fromSystem), (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)WorkTime::new));
            }
            if (UnitOfMeasure.class.isAssignableFrom(t)) {
                return MyBeanDeserializerModifier.sys(d, (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)UnitOfMeasure::fromSystem), (Util.FailableFunction<String, Entity, IOException>)((Util.FailableFunction)UnitOfMeasure::new));
            }
            return super.modifyDeserializer(c, b, d);
        }

        static SystemDeserializer sys(JsonDeserializer<?> deserializer, Util.FailableFunction<String, Entity, IOException> system, Util.FailableFunction<String, Entity, IOException> builder) {
            return new SystemDeserializer(deserializer, system, builder);
        }

        static class SystemDeserializer
        extends JsonDeserializer<Entity>
        implements ResolvableDeserializer {
            final JsonDeserializer<?> deserializer;
            final Util.FailableFunction<String, Entity, IOException> entity;
            final Util.FailableFunction<String, Entity, IOException> system;

            private SystemDeserializer(JsonDeserializer<?> deserializer, Util.FailableFunction<String, Entity, IOException> system, Util.FailableFunction<String, Entity, IOException> entity) {
                this.deserializer = deserializer;
                this.system = system;
                this.entity = entity;
            }

            public Entity deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
                Entity entity;
                if (jsonParser.currentToken() == JsonToken.VALUE_NULL) {
                    return null;
                }
                if (jsonParser.currentToken() == JsonToken.VALUE_STRING) {
                    String text = jsonParser.getText();
                    if (Util.isEmpty((String)text)) {
                        return null;
                    }
                    entity = (Entity)this.entity.apply((Object)text);
                } else {
                    entity = (Entity)this.deserializer.deserialize(jsonParser, context);
                }
                String id = Optional.ofNullable(entity).map(Entity::getId).map(Id::getId).orElse(null);
                Entity systemEntity = Util.isEmpty((String)id) ? null : (Entity)this.system.apply((Object)id);
                return systemEntity != null ? systemEntity : entity;
            }

            public void resolve(DeserializationContext ctxt) throws JsonMappingException {
                ((ResolvableDeserializer)this.deserializer).resolve(ctxt);
            }
        }
    }
}

