/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.serialization.serdes;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.geotab.model.entity.dvirlog.DVIRDefect;
import com.geotab.model.entity.dvirlog.DefectRemark;
import com.geotab.model.entity.dvirlog.RepairStatusType;
import com.geotab.model.entity.group.Defect;
import com.geotab.model.entity.user.User;
import com.geotab.model.serialization.serdes.DefectDeserializer;
import com.geotab.util.DateTimeUtil;
import com.geotab.util.Util;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DVIRDefectDeserializer
extends JsonDeserializer<DVIRDefect> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DVIRDefectDeserializer.class);

    public DVIRDefect deserialize(JsonParser jp, DeserializationContext dc) throws IOException {
        ObjectCodec parserCodec = jp.getCodec();
        JsonNode node = (JsonNode)parserCodec.readTree(jp);
        if (node.isObject()) {
            String id = node.get("id") == null ? null : node.get("id").textValue();
            RepairStatusType repairStatus = node.get("repairStatus") == null ? null : (RepairStatusType)((Object)parserCodec.treeToValue((TreeNode)node.get("repairStatus"), RepairStatusType.class));
            User repairUser = node.get("repairUser") == null ? null : (User)((Object)parserCodec.treeToValue((TreeNode)node.get("repairUser"), User.class));
            List defectRemarks = node.get("defectRemarks") == null ? null : Util.listOf((Object[])((DefectRemark[])parserCodec.treeToValue((TreeNode)node.get("defectRemarks"), DefectRemark[].class)));
            LocalDateTime repairDateTime = node.get("repairDateTime") == null ? null : DateTimeUtil.localDateTimeFromString((String)node.get("repairDateTime").textValue());
            Defect defect = DefectDeserializer.deserializeWithChildren(node.get("defect"));
            return ((DVIRDefect.DVIRDefectBuilder)((Object)((DVIRDefect.DVIRDefectBuilder)((Object)((DVIRDefect.DVIRDefectBuilder)((Object)((DVIRDefect.DVIRDefectBuilder)((Object)((DVIRDefect.DVIRDefectBuilder)((Object)((DVIRDefect.DVIRDefectBuilder)DVIRDefect.builder().id(id)).repairStatus(repairStatus))).repairUser(repairUser))).repairDateTime(repairDateTime))).defect(defect))).defectRemarks(defectRemarks))).build();
        }
        return null;
    }
}

