/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.serialization.serdes;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.geotab.model.entity.group.Defect;
import com.geotab.model.entity.group.DefectSeverity;
import com.geotab.model.entity.group.Group;
import com.geotab.util.Util;
import java.io.IOException;
import java.util.Iterator;

public class DefectDeserializer
extends JsonDeserializer<Defect> {
    public Defect deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jsonParser);
        return DefectDeserializer.deserializeWithChildren(node);
    }

    public static Defect deserializeWithChildren(JsonNode node) {
        if (node == null) {
            return null;
        }
        Defect defect = DefectDeserializer.buildDefect(node);
        if (DefectDeserializer.hasChildren(node)) {
            DefectDeserializer.addDescendants(node.get("children").elements(), defect);
        }
        return defect;
    }

    private static void addDescendants(Iterator<JsonNode> children, Defect parent) {
        while (children.hasNext()) {
            JsonNode child = children.next();
            Defect defect = DefectDeserializer.buildDefect(child);
            if (parent.getChildren() == null) {
                parent.setChildren(Util.listOf((Object[])new Group[0]));
            }
            parent.getChildren().add(defect);
            if (!DefectDeserializer.hasChildren(child)) continue;
            DefectDeserializer.addDescendants(child.get("children").elements(), defect);
        }
    }

    private static boolean hasChildren(JsonNode node) {
        if (node.get("children") == null) {
            return false;
        }
        Iterator grandChildren = node.get("children").elements();
        return grandChildren.hasNext();
    }

    private static Defect buildDefect(JsonNode node) {
        String id = node.get("id") != null ? node.get("id").textValue() : null;
        String name = node.get("name") != null ? node.get("name").textValue() : null;
        String severity = node.get("severity") != null ? node.get("severity").textValue() : null;
        String comments = node.get("comments") != null ? node.get("comments").textValue() : null;
        String reference = node.get("reference") != null ? node.get("reference").textValue() : null;
        Boolean isDefectList = node.get("isDefectList") != null ? Boolean.valueOf(node.get("isDefectList").booleanValue()) : null;
        return ((Defect.DefectBuilder)((Object)((Group.GroupBuilder)((Object)((Defect.DefectBuilder)((Object)((Defect.DefectBuilder)((Object)((Group.GroupBuilder)((Object)((Defect.DefectBuilder)((Defect.DefectBuilder)Defect.defectBuilder().id(id)).name(name)).severity(DefectSeverity.findOrDefault(severity)))).comments(comments))).reference(reference))).isDefectList(isDefectList))).isGlobalReportingGroup(null))).build();
    }
}

