/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.serialization.serdes;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.geotab.model.entity.device.A1;
import com.geotab.model.entity.device.CustomDevice;
import com.geotab.model.entity.device.CustomVehicleDevice;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.device.DeviceType;
import com.geotab.model.entity.device.Go10;
import com.geotab.model.entity.device.Go4v3;
import com.geotab.model.entity.device.Go5;
import com.geotab.model.entity.device.Go6;
import com.geotab.model.entity.device.Go7;
import com.geotab.model.entity.device.Go8;
import com.geotab.model.entity.device.Go9;
import com.geotab.model.entity.device.Go9b;
import com.geotab.model.entity.device.GoAnywhere;
import com.geotab.model.entity.device.GoDriveDevice;
import com.geotab.model.entity.device.GoLegacy;
import com.geotab.model.entity.device.NoDevice;
import com.geotab.model.entity.device.S1;
import com.geotab.model.entity.device.UntrackedAsset;
import com.geotab.model.serialization.ApiJsonSerializer;
import com.geotab.util.Util;
import java.io.IOException;

public class DeviceDeserializer
extends JsonDeserializer<Device> {
    private static final String DEVICE_TYPE_ATTRIBUTE_NAME = "deviceType";
    private static final String SERIAL_NUMBER_ATTRIBUTE_NAME = "serialNumber";
    private static final String PRODUCT_ID_ATTRIBUTE_NAME = "productId";

    public Device deserialize(JsonParser jp, DeserializationContext c) throws IOException {
        ObjectCodec parserCodec = jp.getCodec();
        JsonNode node = (JsonNode)parserCodec.readTree(jp);
        if (node.isTextual()) {
            return NoDevice.getInstance();
        }
        return this.hasDeviceType(node) ? this.byDeviceType(parserCodec, c, node) : this.bySerialNumberAndProductId(parserCodec, c, node);
    }

    private boolean hasDeviceType(JsonNode node) {
        return node.get(DEVICE_TYPE_ATTRIBUTE_NAME) != null && !node.get(DEVICE_TYPE_ATTRIBUTE_NAME).isNull() && DeviceType.findByName(node.get(DEVICE_TYPE_ATTRIBUTE_NAME).textValue()) != null;
    }

    private Device byDeviceType(ObjectCodec pc, DeserializationContext c, JsonNode n) throws IOException {
        switch (n.get(DEVICE_TYPE_ATTRIBUTE_NAME).asText()) {
            case "OldGeotab": 
            case "GO2": 
            case "GO3": 
            case "GO4": {
                return (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)pc, (DeserializationContext)c, (JsonNode)n, GoLegacy.class));
            }
            case "GO4v3": {
                return (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)pc, (DeserializationContext)c, (JsonNode)n, Go4v3.class));
            }
            case "GO5": {
                return (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)pc, (DeserializationContext)c, (JsonNode)n, Go5.class));
            }
            case "GO6": {
                return (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)pc, (DeserializationContext)c, (JsonNode)n, Go6.class));
            }
            case "GO7": {
                return (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)pc, (DeserializationContext)c, (JsonNode)n, Go7.class));
            }
            case "GO8": {
                return (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)pc, (DeserializationContext)c, (JsonNode)n, Go8.class));
            }
            case "GO9": {
                return (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)pc, (DeserializationContext)c, (JsonNode)n, Go9.class));
            }
            case "GO9B": {
                return (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)pc, (DeserializationContext)c, (JsonNode)n, Go9b.class));
            }
            case "GO10": {
                return (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)pc, (DeserializationContext)c, (JsonNode)n, Go10.class));
            }
            case "GoDriveDevice": {
                return (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)pc, (DeserializationContext)c, (JsonNode)n, GoDriveDevice.class));
            }
            case "CustomDevice": {
                return (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)pc, (DeserializationContext)c, (JsonNode)n, CustomDevice.class));
            }
            case "CustomVehicleDevice": {
                return (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)pc, (DeserializationContext)c, (JsonNode)n, CustomVehicleDevice.class));
            }
            case "A1": {
                return (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)pc, (DeserializationContext)c, (JsonNode)n, A1.class));
            }
            case "S1": {
                return (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)pc, (DeserializationContext)c, (JsonNode)n, S1.class));
            }
            case "GoAnywhere": {
                return (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)pc, (DeserializationContext)c, (JsonNode)n, GoAnywhere.class));
            }
            case "None": {
                return (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)pc, (DeserializationContext)c, (JsonNode)n, UntrackedAsset.class));
            }
        }
        return (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)pc, (DeserializationContext)c, (JsonNode)n, Device.class));
    }

    private Device bySerialNumberAndProductId(ObjectCodec oc, DeserializationContext c, JsonNode n) throws IOException {
        if (n.get(SERIAL_NUMBER_ATTRIBUTE_NAME) == null || n.get(SERIAL_NUMBER_ATTRIBUTE_NAME).isNull() || !n.get(SERIAL_NUMBER_ATTRIBUTE_NAME).isTextual()) {
            return (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)oc, (DeserializationContext)c, (JsonNode)n, Device.class));
        }
        String serialNumber = n.get(SERIAL_NUMBER_ATTRIBUTE_NAME).asText();
        int productId = Util.isEmpty((String)serialNumber) ? -1 : ("000-000-0000".equals(serialNumber) && n.get(PRODUCT_ID_ATTRIBUTE_NAME) != null && !n.get(PRODUCT_ID_ATTRIBUTE_NAME).isNull() ? n.get(PRODUCT_ID_ATTRIBUTE_NAME).asInt() : Device.productIdFromSerialNumber(serialNumber));
        DeviceType deviceType = Device.deviceTypeFromProductId(productId);
        Device device = (Device)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)oc, (DeserializationContext)c, (JsonNode)n, deviceType.getType()));
        if (device != null && device.getProductId() == null) {
            device.setProductId(productId);
        }
        return device;
    }
}

