/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.serialization.serdes;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.geotab.model.entity.diagnostic.BasicDiagnostic;
import com.geotab.model.entity.diagnostic.BrpFaultDiagnostic;
import com.geotab.model.entity.diagnostic.DataDiagnostic;
import com.geotab.model.entity.diagnostic.Diagnostic;
import com.geotab.model.entity.diagnostic.DiagnosticType;
import com.geotab.model.entity.diagnostic.GmcccFaultDiagnostic;
import com.geotab.model.entity.diagnostic.GoDiagnostic;
import com.geotab.model.entity.diagnostic.GoFaultDiagnostic;
import com.geotab.model.entity.diagnostic.LegacyFaultDiagnostic;
import com.geotab.model.entity.diagnostic.NoDiagnostic;
import com.geotab.model.entity.diagnostic.ObdFaultDiagnostic;
import com.geotab.model.entity.diagnostic.ObdSaFaultDiagnostic;
import com.geotab.model.entity.diagnostic.Pid;
import com.geotab.model.entity.diagnostic.ProprietaryFaultDiagnostic;
import com.geotab.model.entity.diagnostic.Sid;
import com.geotab.model.entity.diagnostic.SuspectParameter;
import com.geotab.model.serialization.ApiJsonSerializer;
import java.io.IOException;

public class DiagnosticDeserializer
extends JsonDeserializer<Diagnostic> {
    public Diagnostic deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        String id;
        ObjectCodec parserCodec = jsonParser.getCodec();
        JsonNode node = (JsonNode)parserCodec.readTree(jsonParser);
        if (node.isTextual() && "NoDiagnosticId".equals(node.textValue())) {
            return NoDiagnostic.getInstance();
        }
        String string = id = node.get("id") != null ? node.get("id").textValue() : null;
        if ("NoDiagnosticId".equals(id)) {
            return NoDiagnostic.getInstance();
        }
        DiagnosticType diagnosticType = node.get("diagnosticType") == null ? DiagnosticType.NONE : (DiagnosticType)((Object)parserCodec.treeToValue((TreeNode)node.get("diagnosticType"), DiagnosticType.class));
        switch (diagnosticType) {
            case DATA_DIAGNOSTIC: {
                return (Diagnostic)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)parserCodec, (DeserializationContext)context, (JsonNode)node, DataDiagnostic.class));
            }
            case GO_DIAGNOSTIC: {
                return (Diagnostic)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)parserCodec, (DeserializationContext)context, (JsonNode)node, GoDiagnostic.class));
            }
            case PID: {
                return (Diagnostic)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)parserCodec, (DeserializationContext)context, (JsonNode)node, Pid.class));
            }
            case SID: {
                return (Diagnostic)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)parserCodec, (DeserializationContext)context, (JsonNode)node, Sid.class));
            }
            case SUSPECT_PARAMETER: {
                return (Diagnostic)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)parserCodec, (DeserializationContext)context, (JsonNode)node, SuspectParameter.class));
            }
            case OBD_FAULT: {
                return (Diagnostic)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)parserCodec, (DeserializationContext)context, (JsonNode)node, ObdFaultDiagnostic.class));
            }
            case GO_FAULT: {
                return (Diagnostic)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)parserCodec, (DeserializationContext)context, (JsonNode)node, GoFaultDiagnostic.class));
            }
            case OBD_WWH_FAULT: {
                return (Diagnostic)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)parserCodec, (DeserializationContext)context, (JsonNode)node, ObdSaFaultDiagnostic.class));
            }
            case PROPRIETARY_FAULT: {
                return (Diagnostic)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)parserCodec, (DeserializationContext)context, (JsonNode)node, ProprietaryFaultDiagnostic.class));
            }
            case LEGACY_FAULT: {
                return (Diagnostic)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)parserCodec, (DeserializationContext)context, (JsonNode)node, LegacyFaultDiagnostic.class));
            }
            case GMCCC_FAULT: {
                return (Diagnostic)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)parserCodec, (DeserializationContext)context, (JsonNode)node, GmcccFaultDiagnostic.class));
            }
            case BRP_FAULT: {
                return (Diagnostic)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)parserCodec, (DeserializationContext)context, (JsonNode)node, BrpFaultDiagnostic.class));
            }
        }
        return (Diagnostic)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)parserCodec, (DeserializationContext)context, (JsonNode)node, BasicDiagnostic.class));
    }
}

