/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.serialization.serdes;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.geotab.model.Id;
import com.geotab.model.entity.group.Group;
import com.geotab.model.entity.user.Driver;
import com.geotab.model.serialization.serdes.EntityCollectionAsIdCollectionSerializer;
import com.geotab.util.Util;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DutyStatusInfoDriverSerializer
extends JsonSerializer<Driver> {
    public void serialize(Driver driver, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (driver.isSystemEntity()) {
            jsonGenerator.writeString(driver.getId().getId());
        } else {
            Map driverFields = Util.mapBuilder().put((Object)"id", driver.getId() != null ? driver.getId().getId() : null).put((Object)"isDriver", (Object)driver.getIsDriver()).put((Object)"driverGroups", this.convertDriverGroups(driver.getDriverGroups())).build();
            jsonGenerator.writeObject((Object)driverFields);
        }
    }

    private Collection<Id> convertDriverGroups(List<Group> driverGroups) {
        if (Util.isEmpty(driverGroups)) {
            return Collections.emptyList();
        }
        Collection driverGroupsAsEntities = driverGroups.stream().map(group -> group).collect(Collectors.toList());
        EntityCollectionAsIdCollectionSerializer entityCollectionAsIdCollectionSerializer = new EntityCollectionAsIdCollectionSerializer();
        return entityCollectionAsIdCollectionSerializer.convert(driverGroupsAsEntities);
    }
}

