/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.serialization.serdes;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.geotab.model.entity.EntityWithVersion;
import com.geotab.model.entity.textmessage.TextMessage;
import com.geotab.model.serialization.ApiJsonSerializer;
import com.geotab.util.Util;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextMessageDeserializer
extends JsonDeserializer<TextMessage> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TextMessageDeserializer.class);

    public TextMessage deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        ObjectCodec parserCodec = jsonParser.getCodec();
        JsonNode node = (JsonNode)parserCodec.readTree(jsonParser);
        if (node.isTextual()) {
            String textMessageId = node.textValue();
            EntityWithVersion textMessage = null;
            if (Util.isNotEmpty((String)textMessageId)) {
                textMessage = ((TextMessage.TextMessageBuilder)TextMessage.builder().id(textMessageId)).build();
            } else {
                log.warn("Unknown text message with empty id {}.", (Object)textMessageId);
            }
            return textMessage;
        }
        if (node.isObject()) {
            return (TextMessage)((Object)ApiJsonSerializer.defaultDeserialize((ObjectCodec)parserCodec, (DeserializationContext)context, (JsonNode)node, TextMessage.class));
        }
        return null;
    }
}

