/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.util;

import com.geotab.model.CustomParameter;
import com.geotab.model.entity.device.CustomVehicleDevice;
import com.geotab.model.entity.device.DigitalAuxiliariesAware;
import com.geotab.model.entity.device.EngineHoursAdjustmentProviderAware;
import com.geotab.model.entity.device.GoCurve;
import com.geotab.model.entity.device.GoDevice;
import com.geotab.model.entity.device.GoLegacy;
import com.geotab.model.entity.device.GoTalkLanguage;
import com.geotab.model.entity.device.LicensableAware;
import com.geotab.model.entity.device.OdometerAdjustmentProviderAware;
import com.geotab.model.entity.device.RfChannelsAware;
import com.geotab.model.entity.device.VehicleIdentificationNumberAware;
import com.geotab.model.entity.enginetype.EngineTypeGeneric;
import com.geotab.model.entity.group.Group;
import com.geotab.model.wifi.WifiUsageTier;
import com.geotab.util.Util;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;

public final class DeviceDefaultsUtil {
    public static <T> T apply(T t, Consumer<T> fn) {
        fn.accept(t);
        return t;
    }

    public static void addVehicleIdentificationNumberDefaults(VehicleIdentificationNumberAware device) {
        if (device == null) {
            return;
        }
        device.setVehicleIdentificationNumber(Optional.ofNullable(device.getVehicleIdentificationNumber()).orElse(""));
        device.setEngineVehicleIdentificationNumber(Optional.ofNullable(device.getEngineVehicleIdentificationNumber()).orElse("?"));
    }

    public static void addGoDeviceDefaults(GoDevice device) {
        if (device == null) {
            return;
        }
        device.setEngineType(Optional.ofNullable(device.getEngineType()).orElse(EngineTypeGeneric.getInstance()));
        device.setMinor(Optional.ofNullable(device.getMinor()).orElse((short)0));
        device.setMajor(Optional.ofNullable(device.getMajor()).orElse((short)0));
        device.setAutoGroups(Optional.ofNullable(device.getAutoGroups()).orElse(Util.listOf((Object[])new Group[0])));
        device.setMinAccidentSpeed(Optional.ofNullable(device.getMinAccidentSpeed()).orElse(4.0));
        device.setSpeedingOn(Optional.ofNullable(device.getSpeedingOn()).orElse(100.0));
        device.setSpeedingOff(Optional.ofNullable(device.getSpeedingOff()).orElse(90.0));
        device.setGpsOffDelay(Optional.ofNullable(device.getGpsOffDelay()).orElse(0));
        device.setParameterVersion(Optional.ofNullable(device.getParameterVersion()).orElse(0));
        device.setParameterVersionOnDevice(Optional.ofNullable(device.getParameterVersionOnDevice()).orElse((short)0));
        device.setIdleMinutes(Optional.ofNullable(device.getIdleMinutes()).orElse(3));
        device.setGoTalkLanguage(Optional.ofNullable(device.getGoTalkLanguage()).orElse(GoTalkLanguage.ENGLISH));
        device.setFuelTankCapacity(Optional.ofNullable(device.getFuelTankCapacity()).orElse(0.0));
        device.setWifiHotspotLimits(Optional.ofNullable(device.getWifiHotspotLimits()).orElse(Util.listOf((Object[])new WifiUsageTier[0])));
        device.setCustomParameters(Optional.ofNullable(device.getCustomParameters()).orElse(Util.listOf((Object[])new CustomParameter[0])));
        DeviceDefaultsUtil.addLicensableDefaults(device);
    }

    public static void addLicensableDefaults(LicensableAware device) {
        if (device == null) {
            return;
        }
        device.setLicensePlate(Optional.ofNullable(device.getLicensePlate()).orElse(""));
        device.setLicenseState(Optional.ofNullable(device.getLicenseState()).orElse(""));
    }

    public static void addGoLegacyDefaults(GoLegacy device) {
        if (device == null) {
            return;
        }
        device.setDeltaSpeed(Optional.ofNullable(device.getDeltaSpeed()).orElse(9.0));
        device.setDeltaMinSpeed(Optional.ofNullable(device.getDeltaMinSpeed()).orElse(50.0));
        device.setDeltaHeading(Optional.ofNullable(device.getDeltaHeading()).orElse(48));
        device.setDeltaHeadingMinSpeed(Optional.ofNullable(device.getDeltaHeadingMinSpeed()).orElse(20.0));
        device.setDeltaHeadingHS(Optional.ofNullable(device.getDeltaHeadingHS()).orElse(14));
        device.setDeltaHeadingMinSpeedHS(Optional.ofNullable(device.getDeltaHeadingMinSpeedHS()).orElse(72.0));
        device.setDeltaDistance(Optional.ofNullable(device.getDeltaDistance()).orElse(1000));
        device.setHarshBreak(Optional.ofNullable(device.getHarshBreak()).orElse(17.0));
    }

    public static void addRfChannelDefaults(RfChannelsAware device) {
        if (device == null) {
            return;
        }
        device.setChannelCount(Optional.ofNullable(device.getChannelCount()).orElse((byte)1));
        device.setChannel(GoDevice.checkAndPadChannelArray(device.getChannel()));
        device.setFrequencyOffset(Optional.ofNullable(device.getFrequencyOffset()).orElse((byte)1));
        device.setRfParameterVersion((short)0);
    }

    public static void addAuxiliaryDefaults(DigitalAuxiliariesAware device) {
        if (device == null) {
            return;
        }
        device.setEnableAuxWarning(GoDevice.checkAndPadAuxArray(device.getEnableAuxWarning()));
        device.setAuxWarningSpeed(GoDevice.checkAndPadAuxArray(device.getAuxWarningSpeed()));
        device.setIsAuxIgnTrigger(GoDevice.checkAndPadAuxIgnArray(device.getIsAuxIgnTrigger()));
        device.setExternalDeviceShutDownDelay(0);
        device.setImmobilizeArming(3);
        device.setIsAuxInverted(GoDevice.checkAndPadAuxIgnArray(device.getIsAuxInverted()));
    }

    public static void addGoCurveDefaults(GoCurve device) {
        if (device == null) {
            return;
        }
        device.setEnableBeepOnRpm(false);
        device.setRpmValue(3500);
        device.setIsDriverSeatbeltWarningOn(false);
        device.setIsPassengerSeatbeltWarningOn(false);
        device.setIsReverseDetectOn(false);
        device.setIsIoxConnectionEnabled(true);
        device.setAccelerationWarningThreshold(22);
        device.setBrakingWarningThreshold(-34);
        device.setCorneringWarningThreshold(26);
        device.setAccelerometerThresholdWarningFactor(0);
        device.setSeatbeltWarningSpeed(10.0);
        device.setEnableBeepOnDangerousDriving(false);
        device.setIsActiveTrackingEnabled(false);
        DeviceDefaultsUtil.addOdometerAdjustmentProviderDefaults(device);
        DeviceDefaultsUtil.addEngineHoursAdjustmentProviderDefaults(device);
    }

    public static void addOdometerAdjustmentProviderDefaults(OdometerAdjustmentProviderAware device) {
        if (device == null) {
            return;
        }
        device.setOdometerOffset(0.0);
        device.setOdometerFactor(Float.valueOf(1.0f));
    }

    public static void addEngineHoursAdjustmentProviderDefaults(EngineHoursAdjustmentProviderAware device) {
        if (device == null) {
            return;
        }
        device.setEngineHourOffset(0);
    }

    public static void addCustomVehicleDeviceDefaults(CustomVehicleDevice device) {
        if (device == null) {
            return;
        }
        DeviceDefaultsUtil.addVehicleIdentificationNumberDefaults(device);
        DeviceDefaultsUtil.addOdometerAdjustmentProviderDefaults(device);
        DeviceDefaultsUtil.addEngineHoursAdjustmentProviderDefaults(device);
        DeviceDefaultsUtil.addLicensableDefaults(device);
    }

    @Generated
    private DeviceDefaultsUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

