/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.util;

import com.geotab.util.Util;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public final class ThirdPartyHelper {
    public static final Map<Integer, String> THIRD_PARTY_DEVICE_TYPES = Util.mapBuilder().put((Object)10000, (Object)"C1").put((Object)10001, (Object)"C2").put((Object)10002, (Object)"C3").put((Object)10003, (Object)"C4").put((Object)10004, (Object)"C5").put((Object)10005, (Object)"C6").put((Object)10006, (Object)"C7").put((Object)10007, (Object)"C8").put((Object)10008, (Object)"C9").put((Object)10009, (Object)"CA").put((Object)10010, (Object)"CB").put((Object)10011, (Object)"CC").put((Object)10012, (Object)"CD").put((Object)10013, (Object)"CE").put((Object)10014, (Object)"CF").put((Object)10015, (Object)"CG").put((Object)10016, (Object)"CH").put((Object)10017, (Object)"CI").put((Object)10018, (Object)"CJ").put((Object)10019, (Object)"CK").put((Object)10020, (Object)"CL").put((Object)10021, (Object)"CM").put((Object)10022, (Object)"CN").put((Object)10023, (Object)"CO").put((Object)10024, (Object)"CP").put((Object)10025, (Object)"CQ").put((Object)10026, (Object)"CR").put((Object)10027, (Object)"CS").put((Object)10028, (Object)"CT").put((Object)10029, (Object)"CU").put((Object)10030, (Object)"CV").put((Object)10031, (Object)"CW").put((Object)10032, (Object)"CX").put((Object)10033, (Object)"CY").put((Object)10034, (Object)"CZ").put((Object)10035, (Object)"D1").put((Object)10036, (Object)"D2").put((Object)10037, (Object)"D3").put((Object)10038, (Object)"D4").put((Object)10039, (Object)"D5").put((Object)10040, (Object)"D6").put((Object)10041, (Object)"D7").put((Object)10042, (Object)"D8").put((Object)10043, (Object)"D9").put((Object)10044, (Object)"DA").put((Object)10045, (Object)"DB").put((Object)10046, (Object)"DC").put((Object)10047, (Object)"DD").put((Object)10048, (Object)"DE").put((Object)10049, (Object)"DF").put((Object)10050, (Object)"DG").put((Object)10051, (Object)"DH").put((Object)10052, (Object)"DI").put((Object)10053, (Object)"DJ").put((Object)10054, (Object)"DK").put((Object)10055, (Object)"DL").put((Object)10056, (Object)"DM").put((Object)10057, (Object)"DN").put((Object)10058, (Object)"DO").put((Object)10059, (Object)"DP").put((Object)10060, (Object)"DQ").put((Object)10061, (Object)"DR").put((Object)10062, (Object)"DS").put((Object)10063, (Object)"DT").put((Object)10064, (Object)"DU").put((Object)10065, (Object)"DV").put((Object)10066, (Object)"DW").put((Object)10067, (Object)"DX").put((Object)10068, (Object)"DY").put((Object)10069, (Object)"DZ").put((Object)10070, (Object)"E1").put((Object)10071, (Object)"E2").put((Object)10072, (Object)"E3").put((Object)10073, (Object)"E4").put((Object)10074, (Object)"E5").put((Object)10075, (Object)"E6").put((Object)10076, (Object)"E7").put((Object)10077, (Object)"E8").put((Object)10078, (Object)"E9").put((Object)10079, (Object)"EA").put((Object)10080, (Object)"EB").put((Object)10081, (Object)"EC").put((Object)10082, (Object)"ED").put((Object)10083, (Object)"EE").put((Object)10084, (Object)"EF").put((Object)10085, (Object)"EG").put((Object)10086, (Object)"EH").put((Object)10087, (Object)"EI").put((Object)10088, (Object)"EJ").put((Object)10089, (Object)"EK").put((Object)10090, (Object)"EL").put((Object)10091, (Object)"EM").put((Object)10092, (Object)"EN").put((Object)10093, (Object)"EO").put((Object)10094, (Object)"EP").put((Object)10095, (Object)"EQ").put((Object)10096, (Object)"ER").put((Object)10097, (Object)"ES").put((Object)10098, (Object)"ET").put((Object)10099, (Object)"EU").put((Object)10100, (Object)"EV").put((Object)10101, (Object)"EW").put((Object)10102, (Object)"EX").put((Object)10103, (Object)"EY").put((Object)10104, (Object)"EZ").build();
    public static final Set<Integer> OEM_DEVICE_TYPES = new HashSet<Integer>(Util.listOf((Object[])new Integer[]{10023, 10042, 10055, 10056, 10057, 10058, 10059, 10060, 10061, 10062, 10063, 10064, 10065, 10066, 10067, 10068, 10069, 10070, 10071, 10072, 10073, 10074, 10075, 10076, 10077, 10078, 10079, 10080}));

    public static int getThirdPartyProductId(String value) {
        if (Util.isEmpty((String)value)) {
            return 0;
        }
        for (Map.Entry<Integer, String> deviceType : THIRD_PARTY_DEVICE_TYPES.entrySet()) {
            if (!Util.startWithIc((String)deviceType.getValue(), (String)value)) continue;
            return deviceType.getKey();
        }
        return 0;
    }

    public static boolean isThirdPartyVehicleDevice(int productId) {
        return ThirdPartyHelper.isOemDevice(productId) || ThirdPartyHelper.isThirdPartyDevice(productId) && (productId == 10017 || productId == 10026 || productId == 10029 || productId == 10033 || productId == 10040 || productId == 10042 || productId == 10044 || productId == 10085 || productId == 10086 || productId == 10089);
    }

    public static boolean isThirdPartyDevice(String value) {
        return ThirdPartyHelper.getThirdPartyProductId(value) > 0;
    }

    public static boolean isThirdPartyDevice(int productId) {
        return THIRD_PARTY_DEVICE_TYPES.containsKey(productId);
    }

    public static boolean isOemDevice(int productId) {
        return OEM_DEVICE_TYPES.contains(productId);
    }

    @Generated
    private ThirdPartyHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

